/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthclient;

import com.mojang.logging.LogUtils;
import net.bojarsky.bojarskyauthapi.network.S2CVerificationResponsePacket;
import net.bojarsky.bojarskyauthclient.client.ClientAuthHandler;
import net.bojarsky.bojarskyauthclient.client.compat.SystemPerformanceMonitor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;

@Mod(value="bojarskyauthclient")
public class BojarskyAuthClient {
    public static final String MOD_ID = "bojarskyauthclient";
    private static final Logger LOGGER = LogUtils.getLogger();

    public BojarskyAuthClient() {
        LOGGER.info("Loading Bojarsky Auth Client");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLogin);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLogout);
    }

    private void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        SystemPerformanceMonitor.startPeriodicChecks();
    }

    private void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        SystemPerformanceMonitor.stopPeriodicChecks();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("CLIENTAUTH: Client Setup event fired.");
        event.enqueueWork(() -> {
            SystemPerformanceMonitor.performInitialSnapshot();
            S2CVerificationResponsePacket.clientHandler = (packet, ctxSupplier) -> {
                NetworkEvent.Context ctx = (NetworkEvent.Context)ctxSupplier.get();
                ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientAuthHandler.handleVerificationResponse(packet)));
                ctx.setPacketHandled(true);
            };
            LOGGER.info("S2CVerificationResponsePacket client handler assigned.");
        });
        LOGGER.info("CLIENTAUTH: Client Setup tasks enqueued.");
    }
}

