/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthapi.network;

import com.mojang.logging.LogUtils;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;

public class S2CVerificationResponsePacket {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final boolean success;
    public static IClientPacketHandler clientHandler;

    public S2CVerificationResponsePacket(boolean success) {
        this.success = success;
    }

    public S2CVerificationResponsePacket(FriendlyByteBuf buf) {
        this.success = buf.readBoolean();
    }

    public static void encode(S2CVerificationResponsePacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.success);
    }

    public static S2CVerificationResponsePacket decode(FriendlyByteBuf buf) {
        return new S2CVerificationResponsePacket(buf);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public static boolean handlePacket(S2CVerificationResponsePacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        if (clientHandler != null) {
            clientHandler.accept(msg, ctxSupplier);
            return true;
        }
        LOGGER.warn("S2CVerificationResponsePacket received on client, but no handler is registered in API!");
        ctxSupplier.get().setPacketHandled(true);
        return false;
    }

    public static interface IClientPacketHandler
    extends BiConsumer<S2CVerificationResponsePacket, Supplier<NetworkEvent.Context>> {
    }
}

