/*
 * Decompiled with CFR 0.152.
 */
package net.bojarsky.bojarskyauthapi.network;

import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;

public class ClientMetricsPacket {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, String> metricsData;
    public static IMetricsPacketHandler serverHandler;

    public ClientMetricsPacket(Map<String, String> data) {
        this.metricsData = data;
    }

    public static void encode(ClientMetricsPacket packet, FriendlyByteBuf buf) {
        buf.m_236831_(packet.metricsData, FriendlyByteBuf::m_130070_, FriendlyByteBuf::m_130070_);
    }

    public static ClientMetricsPacket decode(FriendlyByteBuf buf) {
        return new ClientMetricsPacket(buf.m_236847_(FriendlyByteBuf::m_130277_, FriendlyByteBuf::m_130277_));
    }

    public Map<String, String> getMetricsData() {
        return this.metricsData;
    }

    public static void handlePacket(ClientMetricsPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                LOGGER.warn("Received ClientMetricsPacket from a null player. Packet ignored.");
                return;
            }
            String playerIdentifier = player.m_36316_().getName() + " (UUID: " + player.m_20148_() + ")";
            if (serverHandler != null) {
                serverHandler.handle(playerIdentifier, packet.getMetricsData());
            } else {
                LOGGER.warn("No server handler assigned for ClientMetricsPacket. Metrics for {} will be ignored.", (Object)playerIdentifier);
            }
        });
        ctx.setPacketHandled(true);
    }

    @FunctionalInterface
    public static interface IMetricsPacketHandler {
        public void handle(String var1, Map<String, String> var2);
    }
}

