/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage;

import com.eerussianguy.betterfoliage.particle.SpritePicker;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ForgeFaceData;

public class Helpers {
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final ModelResourceLocation BACKING_DIRT_MODEL = new ModelResourceLocation("minecraft", "dirt", "inventory");
    public static final ResourceLocation EMPTY = Helpers.identifier("empty");
    public static final BlockFaceUV UV_DEFAULT = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);

    public static ResourceLocation identifier(String name) {
        return new ResourceLocation("betterfoliage", name);
    }

    public static ForgeFaceData forgeFace(boolean ao) {
        return ao ? new ForgeFaceData(-1, 0, 0, true) : new ForgeFaceData(-1, 0, 0, false);
    }

    public static BlockElementFace makeTintedFace(BlockFaceUV uv, boolean ao) {
        return new BlockElementFace(null, 0, "", uv, Helpers.forgeFace(ao));
    }

    public static BlockElementFace makeTintedFace(BlockFaceUV uv) {
        return new BlockElementFace(null, 0, "", uv);
    }

    public static BlockElementFace makeFace(BlockFaceUV uv, boolean ao) {
        return new BlockElementFace(null, -1, "", uv, Helpers.forgeFace(ao));
    }

    public static BlockElementFace makeFace(BlockFaceUV uv) {
        return new BlockElementFace(null, -1, "", uv);
    }

    public static ResourceLocation requireID(JsonObject json, String member) {
        return new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)member, (String)EMPTY.toString()));
    }

    public static ResourceLocation identifierOrEmpty(JsonObject json, String member) {
        if (!json.has(member)) {
            return EMPTY;
        }
        return new ResourceLocation(json.get(member).getAsString());
    }

    public static Collection<Material> makeMaterials(ResourceLocation ... textures) {
        return Arrays.stream(textures).map(texture -> new Material(TextureAtlas.f_118259_, texture)).toList();
    }

    public static BakedQuad makeBakedQuad(BlockElement BlockElement2, BlockElementFace partFace, TextureAtlasSprite atlasSprite, Direction dir, BlockModelRotation modelRotation, ResourceLocation modelResLoc) {
        return new FaceBakery().m_111600_(BlockElement2.f_111308_, BlockElement2.f_111309_, partFace, atlasSprite, dir, (ModelState)modelRotation, BlockElement2.f_111311_, true, modelResLoc);
    }

    public static void assembleFaces(SimpleBakedModel.Builder builder, BlockElement part, TextureAtlasSprite sprite, ResourceLocation modelLocation) {
        for (Map.Entry e : part.f_111310_.entrySet()) {
            Direction d = (Direction)e.getKey();
            builder.m_119530_(d, Helpers.makeBakedQuad(part, (BlockElementFace)e.getValue(), sprite, d, BlockModelRotation.X0_Y0, modelLocation));
        }
    }

    public static void assembleFacesConditional(SimpleBakedModel.Builder builder, BlockElement part, Function<Direction, TextureAtlasSprite> getter, ResourceLocation modelLocation) {
        for (Map.Entry e : part.f_111310_.entrySet()) {
            Direction d = (Direction)e.getKey();
            builder.m_119530_(d, Helpers.makeBakedQuad(part, (BlockElementFace)e.getValue(), getter.apply(d), d, BlockModelRotation.X0_Y0, modelLocation));
        }
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(location);
    }

    public static float[] intervals(int n, float min, float max) {
        float[] f = new float[n];
        for (int i = 0; i < n; ++i) {
            float t = (float)i / (float)(n - 1);
            f[i] = min * t + max * (1.0f - t);
        }
        return f;
    }

    public static void addParticle(TextureSheetParticle particle, List<TextureAtlasSprite> sprites) {
        if (sprites == null) {
            return;
        }
        SpritePicker picker = new SpritePicker();
        picker.rebind(sprites);
        particle.m_108335_((SpriteSet)picker);
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)particle);
    }

    static void addTintedParticle(TextureSheetParticle particle, List<TextureAtlasSprite> sprites, BlockState state, ClientLevel level, BlockPos pos) {
        Minecraft mc = Minecraft.m_91087_();
        SpritePicker picker = new SpritePicker();
        picker.rebind(sprites);
        int color = mc.m_91298_().m_92582_(state, (Level)level, pos);
        if (color == FoliageColor.m_46113_()) {
            color = ((Biome)level.m_204166_(pos).m_203334_()).m_47542_();
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        particle.m_108335_((SpriteSet)picker);
        particle.m_107253_(r, g, b);
        mc.f_91061_.m_107344_((Particle)particle);
    }

    public static void applyTransform(ItemDisplayContext cameraTransformType, PoseStack poseStack, boolean lefty) {
        Minecraft.m_91087_().m_91304_().m_119422_(BACKING_DIRT_MODEL).applyTransform(cameraTransformType, poseStack, lefty);
    }
}

