/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage;

import com.eerussianguy.betterfoliage.BFConfig;
import com.eerussianguy.betterfoliage.BetterFoliage;
import com.eerussianguy.betterfoliage.ForgeEventHandler;
import com.eerussianguy.betterfoliage.Helpers;
import com.eerussianguy.betterfoliage.model.GrassBakedModel;
import com.eerussianguy.betterfoliage.model.GrassLoader;
import com.eerussianguy.betterfoliage.model.LeavesBakedModel;
import com.eerussianguy.betterfoliage.model.LeavesLoader;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class EventHandler {
    private static final Supplier<Boolean> OPTIFINE_LOADED = Suppliers.memoize(() -> {
        try {
            Class.forName("net.optifine.Config");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    });

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(EventHandler::clientSetup);
        bus.addListener(EventHandler::onModelBake);
        bus.addListener(EventHandler::onModelRegister);
        bus.addListener(EventHandler::onLoaderRegister);
        bus.addListener(EventHandler::afterTextureStitch);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        if (((Boolean)BFConfig.CLIENT.forceForgeLighting.get()).booleanValue() && !OPTIFINE_LOADED.get().booleanValue() && !ModList.get().isLoaded("oculus")) {
            ForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.set((Object)true);
        }
        if (ModList.get().isLoaded("tfc")) {
            BetterFoliage.LEAVES_DISABLED_BY_MOD = true;
        }
    }

    private static void onModelBake(ModelEvent.BakingCompleted event) {
        LeavesBakedModel.INSTANCES.forEach(LeavesBakedModel::init);
        GrassBakedModel.INSTANCES.forEach(GrassBakedModel::init);
    }

    private static void afterTextureStitch(TextureStitchEvent.Post event) {
        ForgeEventHandler.clearCache();
    }

    private static void onLoaderRegister(ModelEvent.RegisterGeometryLoaders event) {
        event.register("leaves", (IGeometryLoader)new LeavesLoader());
        event.register("grass", (IGeometryLoader)new GrassLoader());
    }

    private static void onModelRegister(ModelEvent.RegisterAdditional event) {
        event.register(Helpers.identifier("block/better_grass"));
        event.register(Helpers.identifier("block/better_grass_snowed"));
        event.register(Helpers.identifier("block/better_mycelium"));
    }
}

