/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.barrels_2012;

import com.eerussianguy.barrels_2012.BarrelConfig;
import com.eerussianguy.barrels_2012.client.ClientEvents;
import com.eerussianguy.barrels_2012.common.ForgeEvents;
import com.eerussianguy.barrels_2012.common.PlayerGlow;
import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@Mod(value="barrels_2012")
public class Barrels2012 {
    public static final String MOD_ID = "barrels_2012";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Barrels2012() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::registerCaps);
        ForgeEvents.init();
        BarrelConfig.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.init(bus);
        }
    }

    private void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(PlayerGlow.class);
    }

    public static ResourceLocation identifier(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static ModelLayerLocation modelLayer(String name) {
        return new ModelLayerLocation(Barrels2012.identifier(name), "main");
    }

    public static boolean isSealed(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_("BlockEntityTag", 10);
    }

    @Nullable
    public static SlotResult getCurio(LivingEntity entity, Predicate<ItemStack> predicate) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(inv -> inv.findFirstCurio(predicate)).orElse(null);
    }
}

