/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui.core;

import com.mojang.blaze3d.systems.RenderSystem;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponent;
import hunternif.mc.impl.atlas.client.gui.core.GuiViewport;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import net.minecraft.client.gui.GuiGraphics;

public abstract class AGuiScrollbar
extends GuiComponent {
    ITexture texture;
    int textureWidth;
    int textureHeight;
    int capLength;
    int textureBodyLength;
    private static int scrollStep = 18;
    boolean visible = false;
    private boolean isDragged = false;
    private boolean wasClicking = false;
    private boolean usesWheel = true;
    private float contentRatio = 1.0f;
    private float scrollRatio = 0.0f;
    int anchorPos = 0;
    int anchorSize;
    double bodyTextureScale = 1.0;
    int scrollPos = 0;
    final GuiViewport viewport;

    AGuiScrollbar(GuiViewport viewport) {
        this.viewport = viewport;
    }

    public void setTexture(ITexture texture, int width, int height, int capLength) {
        this.texture = texture;
        this.textureWidth = width;
        this.textureHeight = height;
        this.capLength = capLength;
        this.textureBodyLength = this.getTextureLength() - capLength * 2;
        this.setScrollbarWidth(width, height);
    }

    public void setUsesWheel(boolean value) {
        this.usesWheel = value;
    }

    public void updateContent() {
        this.contentRatio = (float)this.getViewportSize() / (float)this.getContentSize();
        this.visible = this.contentRatio < 1.0f;
        this.updateAnchorSize();
        this.updateAnchorPos();
    }

    public void setScrollPos(int scrollPos) {
        this.viewport.content.validateSize();
        this.viewport.validateSize();
        this.doSetScrollPos(scrollPos);
    }

    private void doSetScrollPos(int scrollPos) {
        this.scrollPos = scrollPos = Math.max(0, Math.min(scrollPos, this.getContentSize() - this.getViewportSize()));
        this.scrollRatio = (float)scrollPos / (float)(this.getContentSize() - this.getViewportSize());
        this.updateAnchorPos();
    }

    public void setScrollRatio(float scrollRatio) {
        this.viewport.content.validateSize();
        this.viewport.validateSize();
        this.doSetScrollRatio(scrollRatio);
    }

    private void doSetScrollRatio(float scrollRatio) {
        if (scrollRatio < 0.0f) {
            scrollRatio = 0.0f;
        }
        if (scrollRatio > 1.0f) {
            scrollRatio = 1.0f;
        }
        this.scrollRatio = scrollRatio;
        this.scrollPos = Math.round(scrollRatio * (float)(this.getContentSize() - this.getViewportSize()));
        this.updateAnchorPos();
    }

    @Override
    public boolean m_6050_(double mx, double my, double wheelMove) {
        if (this.usesWheel && this.getParent().isMouseOver && wheelMove != 0.0 && this.visible) {
            wheelMove = wheelMove > 0.0 ? -1.0 : 1.0;
            this.doSetScrollPos((int)((double)this.scrollPos + wheelMove * (double)scrollStep));
            return true;
        }
        return super.m_6050_(mx, my, wheelMove);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOver) {
            if (!this.wasClicking) {
                this.isDragged = true;
            }
            this.wasClicking = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.wasClicking) {
            this.isDragged = false;
            this.wasClicking = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            this.isDragged = false;
            return;
        }
        if (this.isDragged) {
            this.doSetScrollRatio((float)(this.getMousePos(mouseX, mouseY) - this.anchorSize / 2) / (float)(this.getScrollbarLength() - this.anchorSize));
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawAnchor(context);
        RenderSystem.disableBlend();
    }

    private void updateAnchorSize() {
        this.anchorSize = Math.max(this.capLength * 2, Math.round(Math.min(1.0f, this.contentRatio) * (float)this.getScrollbarLength()));
        this.bodyTextureScale = (double)(this.anchorSize - this.capLength * 2) / (double)this.textureBodyLength;
    }

    private void updateAnchorPos() {
        this.anchorPos = Math.round(this.scrollRatio * (float)(this.getViewportSize() - this.anchorSize));
        this.updateContentPos();
    }

    protected abstract int getTextureLength();

    protected abstract int getScrollbarLength();

    protected abstract int getViewportSize();

    protected abstract int getContentSize();

    protected abstract int getMousePos(int var1, int var2);

    protected abstract void drawAnchor(GuiGraphics var1);

    protected abstract void updateContentPos();

    protected abstract void setScrollbarWidth(int var1, int var2);
}

