/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.data.loot;

import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.entity.AlekiShipsEntities;
import com.alekiponi.alekiships.common.entity.vehicle.RowboatEntity;
import com.alekiponi.alekiships.common.entity.vehicle.SloopEntity;
import com.alekiponi.alekiships.common.item.AlekiShipsItems;
import com.alekiponi.alekiships.data.DataGenHelper;
import com.alekiponi.alekiships.util.BoatMaterial;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraftforge.registries.RegistryObject;

public class AlekiShipsEntityLootTables
extends EntityLootSubProvider {
    public static final int FRAME_CAPACITY = 4;
    public static final int ROWBOAT_FRAMES = 6;
    public static final int SLOOP_FRAMES = 24;
    public static final float DESTRUCTION_MODIFIER = 0.2f;
    private static final Set<EntityType<?>> VEHICLE_LOOT_TABLE_TYPES = Stream.concat(AlekiShipsEntities.ROWBOATS.values().stream().map(RegistryObject::get), AlekiShipsEntities.SLOOPS.values().stream().map(RegistryObject::get)).collect(Collectors.toUnmodifiableSet());

    public AlekiShipsEntityLootTables() {
        super(FeatureFlags.f_244280_.m_247355_());
    }

    public static LootTable.Builder createRowboatLootTable(BoatMaterial material) {
        LootTable.Builder rowboatLootTable = LootTable.m_79147_();
        rowboatLootTable.m_79161_(DataGenHelper.lootPoolOf(DataGenHelper.setCountBetween(LootItem.m_79579_((ItemLike)((ItemLike)AlekiShipsBlocks.OARLOCK.get())), 0.0f, 2.0f)));
        rowboatLootTable.m_79161_(DataGenHelper.lootPoolOf(DataGenHelper.setCountBetween(LootItem.m_79579_((ItemLike)material.getDeckItem()), 4.8f, 24.0f)));
        return rowboatLootTable;
    }

    public static LootTable.Builder createSloopLootTable(BoatMaterial material) {
        LootTable.Builder sloopLootTable = LootTable.m_79147_();
        sloopLootTable.m_79161_(DataGenHelper.lootPoolOf(DataGenHelper.setCountBetween(LootItem.m_79579_((ItemLike)((ItemLike)AlekiShipsBlocks.CLEAT.get())), 1.0f, 3.0f)));
        sloopLootTable.m_79161_(DataGenHelper.lootPoolOf(DataGenHelper.setCountBetween(LootItem.m_79579_((ItemLike)Items.f_42655_), 2.0f, 7.0f)));
        sloopLootTable.m_79161_(DataGenHelper.lootPoolOf(DataGenHelper.setCountBetween(LootItem.m_79579_((ItemLike)((ItemLike)AlekiShipsItems.ANCHOR.get())), 0.0f, 1.0f)));
        sloopLootTable.m_79161_(DataGenHelper.lootPoolOf(DataGenHelper.setCountBetween(LootItem.m_79579_((ItemLike)material.getStrippedLog()), 0.0f, 20.0f)));
        sloopLootTable.m_79161_(DataGenHelper.lootPoolOf(DataGenHelper.setCountBetween(LootItem.m_79579_((ItemLike)material.getDeckItem()), 0.0f, 15.0f)));
        sloopLootTable.m_79161_(DataGenHelper.lootPoolOf(DataGenHelper.setCountBetween(LootItem.m_79579_((ItemLike)material.getRailing()), 0.0f, 10.0f)));
        sloopLootTable.m_79161_(DataGenHelper.lootPoolOf(DataGenHelper.setCountBetween(LootItem.m_79579_((ItemLike)material.getDeckItem()), 19.2f, 96.0f)));
        return sloopLootTable;
    }

    public void m_246942_() {
        AlekiShipsEntities.ROWBOATS.forEach(this::dropRowboatTable);
        AlekiShipsEntities.SLOOPS.forEach(this::dropSloopTable);
    }

    protected final void dropSloopTable(BoatMaterial material, RegistryObject<EntityType<SloopEntity>> registryObject) {
        this.m_245309_((EntityType)registryObject.get(), AlekiShipsEntityLootTables.createSloopLootTable(material));
    }

    protected final void dropRowboatTable(BoatMaterial material, RegistryObject<EntityType<RowboatEntity>> registryObject) {
        this.m_245309_((EntityType)registryObject.get(), AlekiShipsEntityLootTables.createRowboatLootTable(material));
    }

    protected boolean m_245552_(EntityType<?> entityType) {
        return VEHICLE_LOOT_TABLE_TYPES.contains(entityType) || super.m_245552_(entityType);
    }

    protected Stream<EntityType<?>> getKnownEntityTypes() {
        return AlekiShipsEntities.ENTITY_TYPES.getEntries().stream().map(RegistryObject::get);
    }
}

