/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehiclehelper;

import com.alekiponi.alekiships.AlekiShips;
import com.alekiponi.alekiships.client.IngameOverlays;
import com.alekiponi.alekiships.common.entity.AlekiShipsEntities;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehiclehelper.AbstractSwitchEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.AnchorEntity;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WindlassSwitchEntity
extends AbstractSwitchEntity {
    protected static final EntityDataAccessor<Float> DATA_ID_ANCHOR_DISTANCE = SynchedEntityData.m_135353_(WindlassSwitchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> DATA_ID_ANCHORED = SynchedEntityData.m_135353_(WindlassSwitchEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public WindlassSwitchEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        Entity entity;
        AnchorEntity anchor;
        super.m_8119_();
        if (!this.m_20160_()) {
            anchor = (AnchorEntity)((EntityType)AlekiShipsEntities.ANCHOR_ENTITY.get()).m_20615_(this.m_9236_());
            assert (anchor != null);
            anchor.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (!anchor.m_20329_(this)) {
                AlekiShips.LOGGER.error("New Anchor: {} unable to ride Windlass: {}", (Object)anchor, (Object)this);
            }
            this.m_9236_().m_7967_((Entity)anchor);
        }
        if ((entity = this.m_146895_()) instanceof AnchorEntity) {
            anchor = (AnchorEntity)entity;
            if (this.getAnchorDistance() > 0.0f && !this.m_9236_().m_8055_(anchor.m_20183_()).m_60795_() && this.m_9236_().m_6425_(anchor.m_20183_()).m_76178_()) {
                this.setAnchored(true);
            } else {
                this.setAnchored(false);
            }
        }
        if (this.getSwitched() && this.getAnchorDistance() < 100.0f && !this.getAnchored()) {
            this.setAnchorDistance(this.getAnchorDistance() + 0.1f);
        } else if (this.getAnchorDistance() > 0.0f && !this.getSwitched()) {
            this.setAnchorDistance(this.getAnchorDistance() - 0.1f);
        }
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.m_20363_(pPassenger)) {
            pCallback.m_20372_(pPassenger, this.m_20185_() + 0.05, this.m_20186_() - (double)this.getAnchorDistance(), this.m_20189_() + 0.05);
        }
    }

    public Vec3 m_7398_(float pPartialTicks) {
        return this.m_20318_(pPartialTicks).m_82520_(0.0, 0.35, 0.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_ANCHOR_DISTANCE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_ANCHORED, (Object)false);
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAnchorDistance(pCompound.m_128457_("anchorDistance"));
        this.setAnchored(pCompound.m_128471_("isAnchored"));
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("anchorDistance", this.getAnchorDistance());
        pCompound.m_128379_("isAnchored", this.getAnchored());
    }

    public void setAnchorDistance(float distance) {
        this.f_19804_.m_135381_(DATA_ID_ANCHOR_DISTANCE, (Object)Float.valueOf(Mth.m_14036_((float)distance, (float)0.0f, (float)100.0f)));
    }

    public float getAnchorDistance() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_ANCHOR_DISTANCE)).floatValue();
    }

    public void setAnchored(boolean anchored) {
        this.f_19804_.m_135381_(DATA_ID_ANCHORED, (Object)anchored);
    }

    public boolean getAnchored() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_ANCHORED);
    }

    @Override
    public ArrayList<IngameOverlays.IconState> getIconStates(Player player) {
        ArrayList<IngameOverlays.IconState> states = new ArrayList<IngameOverlays.IconState>();
        if (this.m_20201_() instanceof AbstractVehicle) {
            if (this.getSwitched()) {
                states.add(IngameOverlays.IconState.ANCHOR_ARROW_UP);
            } else {
                states.add(IngameOverlays.IconState.ANCHOR_ARROW_DOWN);
            }
        }
        return states;
    }
}

