/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.block;

import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.block.AngledWoodenBoatFrameBlock;
import com.alekiponi.alekiships.common.block.CleatBlock;
import com.alekiponi.alekiships.common.block.FlatBoatFrameBlock;
import com.alekiponi.alekiships.common.block.FlatWoodenBoatFrameBlock;
import com.alekiponi.alekiships.common.block.OarlockBlock;
import com.alekiponi.alekiships.common.item.AlekiShipsItems;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.alekiships.util.CommonHelper;
import com.alekiponi.alekiships.util.VanillaWood;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class AlekiShipsBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"alekiships");
    static final SoundType BOAT_FRAME_SOUND = new SoundType(SoundType.f_56756_.f_56731_, SoundType.f_56756_.f_56732_, SoundType.f_56756_.m_56775_(), SoundType.f_56756_.m_56776_(), SoundType.f_56736_.m_56777_(), SoundType.f_56756_.m_56778_(), SoundType.f_56756_.m_56779_());
    public static final RegistryObject<AngledBoatFrameBlock> BOAT_FRAME_ANGLED = AlekiShipsBlocks.registerBlockWithItem("watercraft_frame_angled", () -> new AngledBoatFrameBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244477_).m_60966_().m_60955_().m_60918_(SoundType.f_56756_)));
    public static final EnumMap<VanillaWood, RegistryObject<AngledWoodenBoatFrameBlock>> WOODEN_BOAT_FRAME_ANGLED = CommonHelper.mapOfKeys(VanillaWood.class, vanillaWood -> AlekiShipsBlocks.registerBlock("wood/watercraft_frame/angled/" + vanillaWood.m_7912_(), () -> new AngledWoodenBoatFrameBlock((BoatMaterial)vanillaWood, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BOAT_FRAME_ANGLED.get())).m_60918_(BOAT_FRAME_SOUND))));
    public static final RegistryObject<FlatBoatFrameBlock> BOAT_FRAME_FLAT = AlekiShipsBlocks.registerBlockWithItem("watercraft_frame_flat", () -> new FlatBoatFrameBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BOAT_FRAME_ANGLED.get()))));
    public static final EnumMap<VanillaWood, RegistryObject<FlatWoodenBoatFrameBlock>> WOODEN_BOAT_FRAME_FLAT = CommonHelper.mapOfKeys(VanillaWood.class, vanillaWood -> AlekiShipsBlocks.registerBlock("wood/watercraft_frame/flat/" + vanillaWood.m_7912_(), () -> new FlatWoodenBoatFrameBlock((BoatMaterial)vanillaWood, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)BOAT_FRAME_FLAT.get())).m_60918_(BOAT_FRAME_SOUND))));
    public static final RegistryObject<OarlockBlock> OARLOCK = AlekiShipsBlocks.registerBlockWithItem("oarlock", () -> new OarlockBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60955_()));
    public static final RegistryObject<CleatBlock> CLEAT = AlekiShipsBlocks.registerBlockWithItem("cleat", () -> new CleatBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60955_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithItem(String name, Supplier<T> block) {
        RegistryObject blockRegistryObject = BLOCKS.register(name, block);
        AlekiShipsBlocks.registerBlockItem(name, blockRegistryObject);
        return blockRegistryObject;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        AlekiShipsItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

