/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.client.render.entity.vehicle.vehiclehelper;

import com.alekiponi.alekiships.client.model.entity.CleatKnotEntityModel;
import com.alekiponi.alekiships.client.render.util.AlekiShipsRenderHelper;
import com.alekiponi.alekiships.common.entity.vehicle.AbstractVehicle;
import com.alekiponi.alekiships.common.entity.vehicle.RowboatEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CleatEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class VehicleCleatRenderer
extends EntityRenderer<CleatEntity> {
    private static final ResourceLocation CLEAT_KNOT = new ResourceLocation("alekiships", "textures/entity/cleat_knot.png");
    private final CleatKnotEntityModel<CleatEntity> model = new CleatKnotEntityModel();

    public VehicleCleatRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(CleatEntity cleat, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float rotation;
        Entity entity;
        AbstractVehicle vehicle = cleat.getTrueVehicle();
        if (vehicle != null && LightTexture.m_109883_((int)packedLight) < vehicle.getCompartmentBlockLight()) {
            packedLight = LightTexture.m_109885_((int)Math.max(0, vehicle.getCompartmentBlockLight() - 1), (int)this.m_114508_(cleat, cleat.m_20183_()));
        }
        if ((entity = cleat.getLeashHolder()) == null) {
            return;
        }
        super.m_7392_((Entity)cleat, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
        Entity entity2 = cleat.m_20201_();
        if (entity2 instanceof AbstractVehicle) {
            AbstractVehicle trueVehicle = (AbstractVehicle)entity2;
            rotation = trueVehicle.m_146908_();
        } else {
            rotation = entityYaw;
        }
        if (vehicle != null) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 1.5f, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            if (vehicle instanceof RowboatEntity) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
            } else {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation + 90.0f));
            }
            this.model.setupAnim(cleat, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            VertexConsumer vertexconsumer = bufferSource.m_6299_(this.model.m_103119_(this.getTextureLocation(cleat)));
            this.model.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (vehicle.renderCleatKnotSides()) {
                this.model.getSides().m_104301_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_);
            }
            poseStack.m_85849_();
            AlekiShipsRenderHelper.renderRope(cleat, partialTicks, poseStack, bufferSource, entity, this.m_6086_(cleat, BlockPos.m_274446_((Position)cleat.m_20299_(partialTicks))));
        }
    }

    public ResourceLocation getTextureLocation(CleatEntity cleat) {
        return CLEAT_KNOT;
    }
}

