/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.blocks;

import com.therighthon.afc.AFC;
import com.therighthon.afc.common.blocks.AFCBlocks;
import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.afc.common.blocks.RegistryTreeSpecies;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.FallenLeavesBlock;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.common.blocks.wood.TFCSaplingBlock;
import net.dries007.tfc.world.feature.tree.TFCTreeGrower;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public enum TreeSpecies implements RegistryTreeSpecies
{
    GUM_ARABIC(false, 8, 196),
    ACACIA_KOA(false, 16, 180),
    POPLAR(false, 8, 250),
    MPINGO_BLACKWOOD(false, 11, 200),
    MOUNTAIN_FIR(true, 11, 0),
    BALSAM_FIR(true, 13, 0),
    SCRUB_HICKORY(false, 7, 220),
    RED_SILK_COTTON(false, 18, 150),
    BIGLEAF_MAPLE(false, 9, 215),
    WEEPING_MAPLE(true, 9, 0),
    BLACK_OAK(false, 14, 180),
    LIVE_OAK(false, 10, 155),
    JAGGERY_PALM(false, 6, 249),
    STONE_PINE(true, 11, 0),
    RED_PINE(true, 7, 0),
    TAMARACK(false, 10, 254),
    GIANT_ROSEWOOD(false, 16, 190),
    COAST_REDWOOD(true, 10, 0),
    COAST_SPRUCE(true, 8, 0),
    SITKA_SPRUCE(true, 10, 0),
    BLACK_SPRUCE(true, 12, 0),
    ATLAS_CEDAR(true, 10, 0),
    WEEPING_WILLOW(false, 16, 240),
    RAINBOW_EUCALYPTUS(false, 16, 30),
    MOUNTAIN_ASH(false, 13, 150),
    RUBBER_FIG(false, 13, 80),
    REDCEDAR(true, 10, 0),
    WEEPING_CYPRESS(true, 7, 0),
    BALD_CYPRESS(false, 7, 130),
    SAPELE_MAHOGANY(false, 14, 170),
    SMALL_LEAF_MAHOGANY(false, 11, 240),
    IROKO_TEAK(false, 13, 140),
    FLAME_OF_THE_FOREST(false, 11, 0),
    LEBOMBO_IRONWOOD(false, 8, 230),
    HORSETAIL_IRONWOOD(false, 10, 220);

    public static final TreeSpecies[] VALUES;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final int autumnIndex;
    private final TFCTreeGrower tree;
    private final int daysToGrow;
    private final boolean conifer;

    private TreeSpecies(boolean conifer, int daysToGrow, int autumnIndex) {
        this.autumnIndex = autumnIndex;
        this.tree = new TFCTreeGrower(AFC.treeIdentifier("tree/" + this.serializedName), AFC.treeIdentifier("tree/" + this.serializedName + "_large"));
        this.conifer = conifer;
        this.daysToGrow = daysToGrow;
    }

    @Override
    public int autumnIndex() {
        return this.autumnIndex;
    }

    public String m_7912_() {
        return this.serializedName;
    }

    public boolean isConifer() {
        return this.conifer;
    }

    @Override
    public TFCTreeGrower tree() {
        return this.tree;
    }

    @Override
    public int daysToGrow() {
        return this.defaultDaysToGrow();
    }

    public int defaultDaysToGrow() {
        return this.daysToGrow;
    }

    @Override
    public Supplier<Block> getBlock(BlockType type) {
        return (Supplier)AFCBlocks.TREE_SPECIES.get(this).get((Object)type);
    }

    public boolean hasBlossomingSeason() {
        return this.serializedName.equals("flame_of_the_forest") || this.serializedName.equals("giant_rosewood") || this.serializedName.equals("red_silk_cotton");
    }

    static {
        VALUES = TreeSpecies.values();
    }

    public static enum BlockType {
        LEAVES((self, wood) -> new TFCLeavesBlock(ExtendedProperties.of().mapColor(MapColor.f_283915_).strength(0.5f).sound(SoundType.f_56740_).defaultInstrument().randomTicks().noOcclusion().isViewBlocking(TFCBlocks::never).flammableLikeLeaves(), wood.autumnIndex(), wood.getBlock(self.fallenLeaves()), null){}, false),
        SAPLING((self, wood) -> new TFCSaplingBlock(wood.tree(), ExtendedProperties.of((MapColor)MapColor.f_283915_).noCollission().randomTicks().strength(0.0f).sound(SoundType.f_56740_).flammableLikeLeaves().blockEntity((Supplier)TFCBlockEntities.TICK_COUNTER), wood::daysToGrow, wood == JAGGERY_PALM), false),
        POTTED_SAPLING((self, wood) -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, wood.getBlock(SAPLING), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50229_)), false),
        FALLEN_LEAVES((self, wood) -> new FallenLeavesBlock(ExtendedProperties.of().strength(0.05f, 0.0f).noOcclusion().noCollission().isViewBlocking(TFCBlocks::never).sound(SoundType.f_56758_).flammableLikeWool(), wood.getBlock(self.leaves())), false);

        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;
        private final boolean isPlanksVariant;
        private final BiFunction<BlockType, RegistryTreeSpecies, Block> blockFactory;

        private static ExtendedProperties properties(RegistryTreeSpecies wood) {
            return ExtendedProperties.of((MapColor)MapColor.f_283825_).sound(SoundType.f_56736_);
        }

        private static ExtendedProperties properties(AFCWood wood) {
            return ExtendedProperties.of((MapColor)MapColor.f_283825_).sound(SoundType.f_56736_);
        }

        private BlockType fallenLeaves() {
            return FALLEN_LEAVES;
        }

        private BlockType leaves() {
            return LEAVES;
        }

        private BlockType(BiFunction<BlockType, RegistryTreeSpecies, Block> blockFactory, boolean isPlanksVariant) {
            this(blockFactory, isPlanksVariant, BlockItem::new);
        }

        private BlockType(BiFunction<BlockType, RegistryTreeSpecies, Block> blockFactory, boolean isPlanksVariant, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.blockFactory = blockFactory;
            this.isPlanksVariant = isPlanksVariant;
            this.blockItemFactory = blockItemFactory;
        }

        @Nullable
        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return this.needsItem() ? block -> this.blockItemFactory.apply((Block)block, properties) : null;
        }

        public boolean needsItem() {
            return this != POTTED_SAPLING;
        }

        public Object nameFor(TreeSpecies wood) {
            return (this.isPlanksVariant ? "wood/planks/" + wood.m_7912_() + "_" + this.name() : "wood/" + this.name() + "/" + wood.m_7912_()).toLowerCase(Locale.ROOT);
        }

        public Supplier<Block> create(RegistryTreeSpecies wood) {
            return () -> this.blockFactory.apply(this, wood);
        }

        public String nameFor(RegistryTreeSpecies wood) {
            return ("wood/" + this.name() + "/" + wood.m_7912_()).toLowerCase(Locale.ROOT);
        }
    }
}

