/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.common.blockentities;

import com.therighthon.afc.common.AFCTags;
import com.therighthon.afc.common.blockentities.AFCBlockEntities;
import com.therighthon.afc.common.blocks.TapBlock;
import com.therighthon.afc.common.recipe.TreeTapRecipe;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.FluidParticleOption;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blocks.wood.BranchDirection;
import net.dries007.tfc.common.blocks.wood.LogBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class TapBlockEntity
extends BlockEntity {
    @Nullable
    private BlockPos pourPos = null;

    public TapBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)AFCBlockEntities.TAP_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TapBlockEntity tap) {
        Direction facing = (Direction)state.m_61143_((Property)TapBlock.FACING);
        tap.tickPouring(level, pos, facing);
    }

    public static boolean canPour(IFluidHandler to, FluidStack fluidStack) {
        FluidStack unitFluid = new FluidStack(fluidStack.getFluid(), 1);
        return to.fill(unitFluid, IFluidHandler.FluidAction.SIMULATE) == 1;
    }

    public static boolean pour(IFluidHandler to, FluidStack fluidStack) {
        if (TapBlockEntity.canPour(to, fluidStack)) {
            to.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean isSpring(Level level) {
        Month currentMonth = Calendars.SERVER.getCalendarMonthOfYear();
        return currentMonth == Month.FEBRUARY || currentMonth == Month.MARCH || currentMonth == Month.APRIL || currentMonth == Month.MAY || currentMonth == Month.JUNE;
    }

    public static boolean isTempOkay(Level level, BlockPos pos, float minTemp, float maxTemp) {
        float currentTemp = Climate.getTemperature((Level)level, (BlockPos)pos);
        return currentTemp >= minTemp && currentTemp <= maxTemp;
    }

    public static boolean hasValidTrunk(Level level, BlockPos pos, BlockState state) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        BlockState belowState = level.m_8055_(pos.m_7495_());
        return aboveState == state && belowState == state;
    }

    public static int getTapCount(Level level, BlockPos pos) {
        int tapCount = 0;
        if (Helpers.isBlock((BlockState)level.m_8055_(pos.m_122012_()), AFCTags.Blocks.TREE_TAPS)) {
            ++tapCount;
        }
        if (Helpers.isBlock((BlockState)level.m_8055_(pos.m_122029_()), AFCTags.Blocks.TREE_TAPS)) {
            ++tapCount;
        }
        if (Helpers.isBlock((BlockState)level.m_8055_(pos.m_122019_()), AFCTags.Blocks.TREE_TAPS)) {
            ++tapCount;
        }
        if (Helpers.isBlock((BlockState)level.m_8055_(pos.m_122024_()), AFCTags.Blocks.TREE_TAPS)) {
            ++tapCount;
        }
        if (tapCount == 0) {
            return 1;
        }
        return tapCount;
    }

    public void tickPouring(Level level, BlockPos pos, Direction facing) {
        if (level.m_46467_() % 20L == 0L) {
            BlockState tapState = level.m_8055_(pos);
            if (tapState.m_60710_((LevelReader)level, pos)) {
                BlockPos pourPos = pos.m_7495_();
                BlockEntity blockEntity = level.m_7702_(pourPos);
                BlockPos logPos = switch (facing) {
                    case Direction.NORTH -> pos.m_122019_();
                    case Direction.SOUTH -> pos.m_122012_();
                    case Direction.EAST -> pos.m_122024_();
                    case Direction.WEST -> pos.m_122029_();
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
                };
                BlockState logState = level.m_8055_(logPos);
                TreeTapRecipe recipe = TreeTapRecipe.getRecipe(logState);
                if (recipe != null) {
                    int dripFrequency = 20 * TapBlockEntity.getTapCount(level, logPos);
                    if (level.m_46467_() % (long)dripFrequency == 0L) {
                        if (blockEntity != null) {
                            blockEntity.getCapability(Capabilities.FLUID, Direction.UP).ifPresent(cap -> {
                                this.pourPos = TapBlockEntity.canPour(cap, recipe.getOutput()) ? pourPos : null;
                            });
                        }
                        if (!(this.pourPos == null || recipe.requiresNaturalLog().booleanValue() && logState.m_61143_((Property)LogBlock.BRANCH_DIRECTION) == BranchDirection.NONE || !TapBlockEntity.isTempOkay(level, pos, recipe.getMinTemp(), recipe.getMaxTemp()) || recipe.springOnly().booleanValue() && !TapBlockEntity.isSpring(level) || !TapBlockEntity.hasValidTrunk(level, logPos, logState))) {
                            if (blockEntity != null) {
                                FluidStack fluidStack = recipe.getOutput();
                                if (blockEntity.getCapability(Capabilities.FLUID, Direction.UP).map(cap -> TapBlockEntity.pour(cap, fluidStack)).orElse(false).booleanValue()) {
                                    if (level instanceof ServerLevel) {
                                        double dx;
                                        ServerLevel server = (ServerLevel)level;
                                        double offset = -0.2;
                                        double d = facing.m_122429_() > 0 ? -0.2 : (dx = facing.m_122429_() < 0 ? 0.2 : 0.0);
                                        double dz = facing.m_122431_() > 0 ? -0.2 : (facing.m_122431_() < 0 ? 0.2 : 0.0);
                                        double x = (double)((float)pos.m_123341_() + 0.5f) + dx;
                                        double y = (float)pos.m_123342_() + 0.125f;
                                        double z = (double)((float)pos.m_123343_() + 0.5f) + dz;
                                        Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)((SoundEvent)TFCSounds.BARREL_DRIP.get()));
                                        server.m_8767_((ParticleOptions)new FluidParticleOption((ParticleType)TFCParticles.BARREL_DRIP.get(), fluidStack.getFluid()), x, y, z, 1, 0.0, 0.0, 0.0, 1.0);
                                    }
                                } else {
                                    this.pourPos = null;
                                }
                            } else {
                                this.pourPos = null;
                            }
                        }
                    }
                }
            } else {
                level.m_46961_(pos, true);
            }
        }
    }
}

