/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.afc.client.render.colors;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.calendar.Season;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class AFCColors {
    public static final ResourceLocation FOLIAGE_JACARANDA_COLORS_LOCATION = Helpers.identifier((String)"textures/colormap/foliage_jacaranda.png");
    public static final ResourceLocation FOLIAGE_YELLOW_COLORS_LOCATION = Helpers.identifier((String)"textures/colormap/foliage_yellow.png");
    public static final ResourceLocation FOLIAGE_ORANGE_COLORS_LOCATION = Helpers.identifier((String)"textures/colormap/foliage_orange.png");
    public static final ResourceLocation FOLIAGE_RED_COLORS_LOCATION = Helpers.identifier((String)"textures/colormap/foliage_red.png");
    private static int[] FOLIAGE_JACARANDA_COLORS_CACHE = new int[65536];
    private static int[] FOLIAGE_YELLOW_COLORS_CACHE = new int[65536];
    private static int[] FOLIAGE_ORANGE_COLORS_CACHE = new int[65536];
    private static int[] FOLIAGE_RED_COLORS_CACHE = new int[65536];

    public static void setFoliageJacarandaColors(int[] foliageColorsCache) {
        FOLIAGE_JACARANDA_COLORS_CACHE = foliageColorsCache;
    }

    public static void setFoliageYellowColors(int[] foliageColorsCache) {
        FOLIAGE_YELLOW_COLORS_CACHE = foliageColorsCache;
    }

    public static void setFoliageOrangeColors(int[] foliageColorsCache) {
        FOLIAGE_ORANGE_COLORS_CACHE = foliageColorsCache;
    }

    public static void setFoliageRedColors(int[] foliageColorsCache) {
        FOLIAGE_RED_COLORS_CACHE = foliageColorsCache;
    }

    public static int getYellowIpeFoliageColor(@Nullable BlockPos pos, int tintIndex, int autumnIndex) {
        if (pos != null && tintIndex == 0) {
            switch (AFCColors.getAdjustedNoisyMonth(pos)) {
                case MARCH: 
                case APRIL: {
                    int index = Helpers.hash((long)91273491823412341L, (BlockPos)pos);
                    return FOLIAGE_YELLOW_COLORS_CACHE[index & 0xFFFF];
                }
            }
            return TFCColors.getSeasonalFoliageColor((BlockPos)pos, (int)tintIndex, (int)autumnIndex);
        }
        return -1;
    }

    public static int getJacarandaFoliageColor(@Nullable BlockPos pos, int tintIndex, int autumnIndex) {
        if (pos != null && tintIndex == 0) {
            switch (AFCColors.getAdjustedNoisyMonth(pos)) {
                case MARCH: 
                case APRIL: {
                    int index = Helpers.hash((long)91273491823412341L, (BlockPos)pos);
                    return FOLIAGE_JACARANDA_COLORS_CACHE[index & 0xFFFF];
                }
            }
            return TFCColors.getSeasonalFoliageColor((BlockPos)pos, (int)tintIndex, (int)autumnIndex);
        }
        return -1;
    }

    public static int getKapokFoliageColor(@Nullable BlockPos pos, int tintIndex, int autumnIndex) {
        if (pos != null && tintIndex == 0) {
            switch (AFCColors.getAdjustedNoisyMonth(pos)) {
                case APRIL: 
                case MAY: {
                    int index = Helpers.hash((long)91273491823412341L, (BlockPos)pos);
                    return FOLIAGE_RED_COLORS_CACHE[index & 0xFFFF];
                }
            }
            return TFCColors.getSeasonalFoliageColor((BlockPos)pos, (int)tintIndex, (int)autumnIndex);
        }
        return -1;
    }

    public static int getFlameOfTheForestFoliageColor(@Nullable BlockPos pos, int tintIndex, int autumnIndex) {
        if (pos != null && tintIndex == 0) {
            switch (AFCColors.getAdjustedNoisyMonth(pos)) {
                case MARCH: 
                case APRIL: {
                    int index = Helpers.hash((long)91273491823412341L, (BlockPos)pos);
                    return FOLIAGE_ORANGE_COLORS_CACHE[index & 0xFFFF];
                }
            }
            return TFCColors.getSeasonalFoliageColor((BlockPos)pos, (int)tintIndex, (int)autumnIndex);
        }
        return -1;
    }

    private static Season getAdjustedNoisySeason(BlockPos pos) {
        Month currentMonth = Calendars.CLIENT.getCalendarMonthOfYear();
        Season season = currentMonth.getSeason();
        float seasonDelta = 0.0f;
        float monthDelta = Calendars.CLIENT.getCalendarFractionOfMonth();
        switch (currentMonth) {
            case MAY: 
            case FEBRUARY: 
            case AUGUST: 
            case NOVEMBER: {
                seasonDelta = 0.5f * monthDelta;
                break;
            }
            case MARCH: 
            case JUNE: 
            case SEPTEMBER: 
            case DECEMBER: {
                season = season.previous();
                seasonDelta = 0.5f + 0.5f * monthDelta;
            }
        }
        int positionDeltaHash = Helpers.hash((long)836494186029734123L, (BlockPos)pos) & 0xFF;
        if ((float)positionDeltaHash < 256.0f * seasonDelta) {
            season = season.next();
        }
        return season;
    }

    private static Month getAdjustedNoisyMonth(BlockPos pos) {
        Month month = Calendars.CLIENT.getCalendarMonthOfYear();
        float monthT = Calendars.CLIENT.getCalendarFractionOfMonth() - 0.5f;
        float monthDelta = 16.0f * (monthT * monthT * monthT * monthT);
        int positionDeltaHash = Helpers.hash((long)836494186029734123L, (BlockPos)pos) & 0xFF;
        if ((float)positionDeltaHash < 256.0f * monthDelta) {
            month = (double)monthT >= 0.5 ? month.next() : AFCColors.getPreviousMonth(month);
        }
        return month;
    }

    private static Month getPreviousMonth(Month month) {
        return switch (month) {
            default -> throw new IncompatibleClassChangeError();
            case Month.JANUARY -> Month.DECEMBER;
            case Month.FEBRUARY -> Month.JANUARY;
            case Month.MARCH -> Month.FEBRUARY;
            case Month.APRIL -> Month.MARCH;
            case Month.MAY -> Month.APRIL;
            case Month.JUNE -> Month.MAY;
            case Month.JULY -> Month.JUNE;
            case Month.AUGUST -> Month.JULY;
            case Month.SEPTEMBER -> Month.AUGUST;
            case Month.OCTOBER -> Month.SEPTEMBER;
            case Month.NOVEMBER -> Month.OCTOBER;
            case Month.DECEMBER -> Month.NOVEMBER;
        };
    }

    private static int getClimateColor(int[] colorCache, BlockPos pos) {
        Level level = ClientHelpers.getLevel();
        if (level != null) {
            float temperature = Climate.getTemperature((Level)level, (BlockPos)pos);
            float rainfall = Climate.getRainfall((Level)level, (BlockPos)pos);
            return AFCColors.getClimateColor(colorCache, temperature, rainfall);
        }
        return 0;
    }

    private static int getClimateColor(int[] colorCache, float temperature, float rainfall) {
        int temperatureIndex = 255 - Mth.m_14045_((int)((int)((temperature + 30.0f) * 255.0f / 60.0f)), (int)0, (int)255);
        int rainfallIndex = 255 - Mth.m_14045_((int)((int)(rainfall * 255.0f / 500.0f)), (int)0, (int)255);
        return colorCache[temperatureIndex | rainfallIndex << 8];
    }
}

