/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.ShoreSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;

public class RiverSurfaceBuilder
extends ShoreSurfaceBuilder {
    public static final SurfaceBuilderFactory INSTANCE = RiverSurfaceBuilder::new;

    protected RiverSurfaceBuilder(long seed) {
        super(seed);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        BiomeExtension biome = context.originalBiome();
        if (biome.isShore()) {
            super.buildSurface(context, startY, endY);
        } else if (!biome.hasSandyRiverShores()) {
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY);
        } else {
            SurfaceState state = SurfaceStates.GRAVEL;
            if (context.getSlope() < 2.0) {
                state = SurfaceStates.GRASS;
            } else if (context.getSlope() < 5.0) {
                state = SurfaceStates.RIVER_SAND;
            }
            NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, state, SurfaceStates.GRAVEL, SurfaceStates.SANDSTONE_OR_GRAVEL);
        }
    }
}

