/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface.builder;

import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.surface.SurfaceBuilderContext;
import net.dries007.tfc.world.surface.SurfaceStates;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;

public class LowlandsSurfaceBuilder
implements SurfaceBuilder {
    public static final SurfaceBuilderFactory INSTANCE = LowlandsSurfaceBuilder::new;
    private final Noise2D surfaceMaterialNoise;

    public LowlandsSurfaceBuilder(long seed) {
        this.surfaceMaterialNoise = new OpenSimplex2D(seed).octaves(2).spread(0.04f);
    }

    @Override
    public void buildSurface(SurfaceBuilderContext context, int startY, int endY) {
        float noise = (float)this.surfaceMaterialNoise.noise(context.pos().m_123341_(), context.pos().m_123343_()) * 0.9f + context.random().m_188501_() * 0.1f;
        NormalSurfaceBuilder.INSTANCE.buildSurface(context, startY, endY, noise < 0.0f ? SurfaceStates.GRASS : SurfaceStates.MUD, SurfaceStates.MUD, SurfaceStates.DIRT, noise > 0.0f ? SurfaceStates.DIRT : SurfaceStates.MUD, SurfaceStates.MUD);
    }
}

