/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.surface;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.RockData;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.dries007.tfc.world.settings.RockSettings;
import net.dries007.tfc.world.surface.SurfaceState;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class SurfaceBuilderContext {
    private final LevelAccessor level;
    private final ChunkAccess chunk;
    private final ChunkData chunkData;
    private final RockData rockData;
    private final RandomSource random;
    private final long seed;
    private final int seaLevel;
    private final int minY;
    private final Set<BlockState> defaultBlockStates;
    private final Set<BlockState> defaultFluidStates;
    private final BlockPos.MutableBlockPos cursor;
    @Nullable
    private BiomeExtension biome;
    @Nullable
    private BiomeExtension originalBiome;
    private double biomeWeight;
    private double slope;
    private float temperature;
    private float rainfall;
    private boolean salty;

    public SurfaceBuilderContext(LevelAccessor level, ChunkAccess chunk, ChunkData chunkData, RandomSource random, long seed, RockLayerSettings rockLayerSettings, int seaLevel, int minY) {
        this.level = level;
        this.chunk = chunk;
        this.chunkData = chunkData;
        this.rockData = chunkData.getRockData();
        this.random = random;
        this.seed = seed;
        this.seaLevel = seaLevel;
        this.minY = minY;
        this.defaultBlockStates = new ObjectOpenHashSet();
        this.defaultFluidStates = new ObjectOpenHashSet();
        this.cursor = new BlockPos.MutableBlockPos();
        for (RockSettings rock : rockLayerSettings.getRocks()) {
            this.defaultBlockStates.add(rock.raw().m_49966_());
        }
        this.defaultFluidStates.add(Blocks.f_49990_.m_49966_());
    }

    public void buildSurface(BiomeExtension biome, BiomeExtension originalBiome, double biomeWeight, boolean salty, SurfaceBuilder builder, int x, int y, int z, double slope) {
        this.biome = biome;
        this.originalBiome = originalBiome;
        this.biomeWeight = biomeWeight;
        this.slope = slope;
        this.temperature = this.chunkData.getAverageTemp(x, z);
        this.rainfall = this.chunkData.getRainfall(x, z);
        this.salty = salty;
        int oceanFloor = this.chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        int actualMinSurfaceHeight = Math.max(this.minY, Math.min(y, oceanFloor) - 20);
        this.cursor.m_122178_(x, 0, z);
        builder.buildSurface(this, y, actualMinSurfaceHeight);
    }

    public BiomeExtension biome() {
        assert (this.biome != null);
        return this.biome;
    }

    public BiomeExtension originalBiome() {
        assert (this.originalBiome != null);
        return this.originalBiome;
    }

    public double weight() {
        return this.biomeWeight;
    }

    public BlockPos pos() {
        return this.cursor;
    }

    public RockSettings getRock() {
        return this.rockData.getRock(this.cursor.m_123341_(), this.cursor.m_123342_(), this.cursor.m_123343_());
    }

    public RockSettings getSeaLevelRock() {
        return this.rockData.getRock(this.cursor.m_123341_(), this.seaLevel, this.cursor.m_123343_());
    }

    public RockSettings getBottomRock() {
        return this.rockData.getRock(this.cursor.m_123341_(), -64, this.cursor.m_123343_());
    }

    public float averageTemperature() {
        return this.temperature;
    }

    public float rainfall() {
        return this.rainfall;
    }

    public boolean salty() {
        return this.salty;
    }

    public BlockState getBlockState(int y) {
        return this.chunk.m_8055_((BlockPos)this.cursor.m_142448_(y));
    }

    public void setBlockState(int y, SurfaceState state) {
        this.cursor.m_142448_(y);
        state.setState(this);
    }

    public void setBlockState(int y, BlockState state) {
        this.chunk.m_6978_((BlockPos)this.cursor.m_142448_(y), state, false);
    }

    public LevelAccessor level() {
        return this.level;
    }

    public ChunkAccess chunk() {
        return this.chunk;
    }

    public ChunkData getChunkData() {
        return this.chunkData;
    }

    public RandomSource random() {
        return this.random;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public boolean isDefaultBlock(BlockState state) {
        return this.defaultBlockStates.contains(state);
    }

    public boolean isDefaultFluid(BlockState state) {
        return this.defaultFluidStates.contains(state);
    }

    public int calculateAltitudeSlopeSurfaceDepth(int y, int maxDepth, int minimumReturnValue) {
        double slopeFactor = 1.0 - Mth.m_14008_((double)(this.slope / 15.0), (double)0.0, (double)1.0);
        double altitudeFactor = y < this.seaLevel ? Mth.m_144851_((double)((double)(this.seaLevel - y) / 15.0), (double)0.0, (double)0.4, (double)1.0, (double)1.4) : Mth.m_144851_((double)((double)(y - this.seaLevel) / 140.0), (double)0.0, (double)0.8, (double)1.0, (double)0.2);
        return Mth.m_14045_((int)((int)Mth.m_14139_((double)(slopeFactor * altitudeFactor), (double)minimumReturnValue, (double)maxDepth)), (int)minimumReturnValue, (int)maxDepth);
    }
}

