/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.dries007.tfc.common.blocks.SandstoneBlockType;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.Codecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public record RockSettings(Block raw, Block hardened, Block gravel, Block cobble, Block sand, Block sandstone, Optional<Block> spike, Optional<Block> loose, Optional<Block> mossyLoose) {
    private static final Map<ResourceLocation, RockSettings> PRESETS = new ConcurrentHashMap<ResourceLocation, RockSettings>();
    public static final Codec<RockSettings> CODEC = Codecs.presetIdOrDirectCodec(RecordCodecBuilder.create(instance -> instance.group((App)Codecs.BLOCK.fieldOf("raw").forGetter(c -> c.raw), (App)Codecs.BLOCK.fieldOf("hardened").forGetter(c -> c.hardened), (App)Codecs.BLOCK.fieldOf("gravel").forGetter(c -> c.gravel), (App)Codecs.BLOCK.fieldOf("cobble").forGetter(c -> c.cobble), (App)Codecs.BLOCK.fieldOf("sand").forGetter(c -> c.sand), (App)Codecs.BLOCK.fieldOf("sandstone").forGetter(c -> c.sandstone), (App)Codecs.optionalFieldOf(Codecs.BLOCK, "spike").forGetter(c -> c.spike), (App)Codecs.optionalFieldOf(Codecs.BLOCK, "loose").forGetter(c -> c.loose), (App)Codecs.optionalFieldOf(Codecs.BLOCK, "mossy_loose").forGetter(c -> c.mossyLoose)).apply((Applicative)instance, RockSettings::new)), PRESETS);

    public static RockSettings register(ResourceLocation id, RockSettings settings) {
        PRESETS.put(id, settings);
        return settings;
    }

    public static void registerDefaultRocks() {
        for (Rock rock : Rock.values()) {
            ResourceLocation id = Helpers.identifier(rock.m_7912_());
            Map<Rock.BlockType, RegistryObject<Block>> blocks = TFCBlocks.ROCK_BLOCKS.get(rock);
            RockSettings.register(id, new RockSettings((Block)blocks.get((Object)Rock.BlockType.RAW).get(), (Block)blocks.get((Object)Rock.BlockType.HARDENED).get(), (Block)blocks.get((Object)Rock.BlockType.GRAVEL).get(), (Block)blocks.get((Object)Rock.BlockType.COBBLE).get(), (Block)TFCBlocks.SAND.get((Object)rock.getSandType()).get(), (Block)TFCBlocks.SANDSTONE.get((Object)rock.getSandType()).get((Object)SandstoneBlockType.RAW).get(), Optional.of((Block)blocks.get((Object)Rock.BlockType.SPIKE).get()), Optional.of((Block)blocks.get((Object)Rock.BlockType.LOOSE).get()), Optional.of((Block)blocks.get((Object)Rock.BlockType.MOSSY_LOOSE).get())));
        }
    }

    public boolean isRawOrHardened(BlockState state) {
        return Helpers.isBlock(state, this.raw()) || Helpers.isBlock(state, this.hardened());
    }
}

