/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.river;

import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;

public enum Flow implements StringRepresentable
{
    EEE("e"),
    NEE("nee"),
    N_E("ne"),
    NNE("nne"),
    NNN("n"),
    NNW("nnw"),
    N_W("nw"),
    NWW("nww"),
    WWW("w"),
    SWW("sww"),
    S_W("sw"),
    SSW("ssw"),
    SSS("s"),
    SSE("sse"),
    S_E("se"),
    SEE("see"),
    ___("none");

    public static final Flow NONE;
    private static final Flow[] VALUES;
    private static final int MODULUS;
    private final String name;
    private final Vec3 vector;

    public static Flow valueOf(int i) {
        return i >= 0 && i < VALUES.length ? VALUES[i] : NONE;
    }

    public static Flow fromAngle(double angle) {
        int ordinal = (int)Math.round(8.0 * (angle / 3.1415927410125732));
        if (ordinal < 0) {
            ordinal += MODULUS;
        }
        return VALUES[ordinal];
    }

    public static Flow lerp(Flow flow00, Flow flow01, Flow flow10, Flow flow11, float delta0, float delta1) {
        Flow flow0 = Flow.lerp(flow00, flow01, delta0);
        Flow flow1 = Flow.lerp(flow10, flow11, delta0);
        return Flow.lerp(flow0, flow1, delta1, Flow.lerpWeight(flow00, flow01, delta0), Flow.lerpWeight(flow10, flow11, delta0));
    }

    public static Flow lerp(Flow left, Flow right, float delta) {
        return Flow.lerp(left, right, delta, left == NONE ? 0.0f : 1.0f, right == NONE ? 0.0f : 1.0f);
    }

    private static Flow lerp(Flow left, Flow right, float delta, float weightLeft, float weightRight) {
        if (left == NONE && right == NONE) {
            return NONE;
        }
        if (left == NONE) {
            return Mth.m_14179_((float)delta, (float)weightLeft, (float)weightRight) < 0.5f ? left : right;
        }
        if (right == NONE) {
            return Mth.m_14179_((float)delta, (float)weightLeft, (float)weightRight) >= 0.5f ? left : right;
        }
        return Flow.lerpNonEmpty(left, right, delta);
    }

    private static Flow lerpNonEmpty(Flow left, Flow right, float delta) {
        int rightValue;
        int ordinalDistance = Math.abs(left.ordinal() - right.ordinal());
        if (ordinalDistance == 8) {
            return delta == 0.5f ? NONE : (delta < 0.5f ? left : right);
        }
        if (ordinalDistance < 8) {
            return VALUES[Flow.lerp(left.ordinal(), right.ordinal(), delta)];
        }
        int leftValue = left.ordinal();
        if (leftValue < (rightValue = right.ordinal())) {
            leftValue += MODULUS;
        } else {
            rightValue += MODULUS;
        }
        return VALUES[Flow.lerp(leftValue, rightValue, delta) % MODULUS];
    }

    private static int lerp(int left, int right, float delta) {
        return Math.round(Mth.m_14179_((float)delta, (float)left, (float)right));
    }

    private static float lerpWeight(Flow left, Flow right, float delta) {
        if (left == NONE && right == NONE) {
            return 0.0f;
        }
        if (left == NONE) {
            return delta;
        }
        if (right == NONE) {
            return 1.0f - delta;
        }
        return 1.0f;
    }

    private Flow(String name) {
        this.name = name;
        float angle = (float)this.ordinal() * 0.125f * (float)Math.PI;
        this.vector = new Vec3((double)Mth.m_14089_((float)angle), 0.0, (double)(-Mth.m_14031_((float)angle)));
    }

    public String m_7912_() {
        return this.name;
    }

    public Vec3 getVector() {
        return this.vector;
    }

    static {
        NONE = ___;
        VALUES = Flow.values();
        MODULUS = VALUES.length - 1;
    }
}

