/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import java.util.List;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.noise.FastNoiseLite;
import net.dries007.tfc.world.region.RiverEdge;
import org.jetbrains.annotations.Nullable;

public final class Region {
    private final double cellX;
    private final double cellY;
    private final double noise;
    private int minX;
    private int minZ;
    private int maxX;
    private int maxZ;
    private int sizeX;
    private int sizeZ;
    private Point[] data;
    @Nullable
    private List<RiverEdge> rivers;

    Region(Cellular2D.Cell cell) {
        this.cellX = cell.x();
        this.cellY = cell.y();
        this.noise = cell.noise();
        int cellX = FastNoiseLite.FastRound(cell.x());
        int cellZ = FastNoiseLite.FastRound(cell.y());
        this.minX = cellX - 100;
        this.minZ = cellZ - 100;
        this.maxX = cellX + 100;
        this.maxZ = cellZ + 100;
        this.sizeX = 1 + this.maxX - this.minX;
        this.sizeZ = 1 + this.maxZ - this.minZ;
        this.data = new Point[40401];
    }

    public Point atInit(int gridX, int gridZ) {
        int index = this.index(gridX, gridZ);
        Point point = new Point();
        assert (this.data[index] == null);
        this.data[index] = point;
        return point;
    }

    public Point requireAt(int gridX, int gridZ) {
        Point point = this.at(gridX, gridZ);
        assert (point != null) : "Region %s does not contain point at (%d, %d)".formatted(this, gridX, gridZ);
        return point;
    }

    @Nullable
    public Point at(int gridX, int gridZ) {
        return this.data[this.index(gridX, gridZ)];
    }

    @Nullable
    public Point maybeAt(int gridX, int gridZ) {
        return this.isIn(gridX, gridZ) ? this.data[this.index(gridX, gridZ)] : null;
    }

    public boolean isIn(int gridX, int gridZ) {
        return gridX >= this.minX && gridX <= this.maxX && gridZ >= this.minZ && gridZ <= this.maxZ;
    }

    public int offset(int index, int offsetX, int offsetZ) {
        int localX = offsetX + index % this.sizeX;
        int localZ = offsetZ + index / this.sizeX;
        return localX >= 0 && localX < this.sizeX && localZ >= 0 && localZ < this.sizeZ ? localX + this.sizeX * localZ : -1;
    }

    public int index(int gridX, int gridZ) {
        assert (this.isIn(gridX, gridZ)) : "Point (" + gridX + ", " + gridZ + ") not in region [" + this.minX + ", " + this.maxX + "] x [" + this.minZ + ", " + this.maxZ + "]";
        int localX = gridX - this.minX;
        int localZ = gridZ - this.minZ;
        return localX + this.sizeX * localZ;
    }

    public double noise() {
        return this.noise;
    }

    public int minX() {
        return this.minX;
    }

    public int minZ() {
        return this.minZ;
    }

    public int maxX() {
        return this.maxX;
    }

    public int maxZ() {
        return this.maxZ;
    }

    public int sizeX() {
        return this.sizeX;
    }

    public int sizeZ() {
        return this.sizeZ;
    }

    public void setRegionArea(Point[] data, int minX, int minZ, int maxX, int maxZ) {
        this.data = data;
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.sizeX = 1 + maxX - minX;
        this.sizeZ = 1 + maxZ - minZ;
        assert (data.length == this.sizeX * this.sizeZ) : "setRegionArea() data.length = %d != sizeX (%d) * sizeZ (%d)".formatted(data.length, this.sizeX, this.sizeZ);
    }

    public void setRivers(List<RiverEdge> rivers) {
        assert (this.rivers == null);
        this.rivers = rivers;
    }

    public Point[] data() {
        return this.data;
    }

    public List<RiverEdge> rivers() {
        assert (this.rivers != null);
        return this.rivers;
    }

    public String toString() {
        return "Region [%d, %d] x [%d, %d] at cell (%f, %f)".formatted(this.minX, this.maxX, this.minZ, this.maxZ, this.cellX, this.cellY);
    }

    public static class Point {
        static final short FLAG_LAND = 1;
        static final short FLAG_ISLAND = 2;
        static final short FLAG_RIVER = 4;
        static final short FLAG_LAKE = 8;
        static final short FLAG_MOUNTAIN = 16;
        static final short FLAG_COASTAL_MOUNTAIN = 32;
        public byte distanceToOcean = 0;
        public byte distanceToEdge = 0;
        public byte baseOceanDepth = 0;
        public byte baseLandHeight = 0;
        public byte biomeAltitude = 0;
        public float rainfall;
        public float temperature;
        public int biome = TFCLayers.OCEAN;
        public int rock = 0;
        private short flags;

        public boolean land() {
            return (this.flags & 1) != 0;
        }

        public boolean island() {
            return (this.flags & 2) != 0;
        }

        public boolean shore() {
            return this.distanceToOcean == -2;
        }

        public boolean river() {
            return (this.flags & 4) != 0;
        }

        public boolean lake() {
            return (this.flags & 8) != 0;
        }

        public boolean mountain() {
            return (this.flags & 0x10) != 0;
        }

        public boolean coastalMountain() {
            return (this.flags & 0x20) != 0;
        }

        public int discreteBiomeAltitude() {
            return Math.floorDiv(this.biomeAltitude, 4);
        }

        public void setLand() {
            this.flags = (short)(this.flags | 1);
        }

        public void setIsland() {
            this.flags = (short)(this.flags | 2);
        }

        public void setShore() {
            this.distanceToOcean = (byte)-2;
        }

        public void setRiver() {
            this.flags = (short)(this.flags | 4);
        }

        public void setLake() {
            this.flags = (short)(this.flags | 8);
        }

        public void setMountain() {
            this.flags = (short)(this.flags | 0x10);
        }

        public void setCoastalMountain() {
            this.flags = (short)(this.flags | 0x20);
        }
    }
}

