/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum FloodFillSmallOceans implements RegionTask
{
    INSTANCE;

    private static final int SMALL_OCEAN_FILL_THRESHOLD = 180;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        BitSet explored = new BitSet(region.sizeX() * region.sizeZ());
        for (int dx = 0; dx < region.sizeX(); ++dx) {
            for (int dz = 0; dz < region.sizeZ(); ++dz) {
                int index = dx + region.sizeX() * dz;
                Region.Point point = region.data()[index];
                if (explored.get(index) || point == null || point.land()) continue;
                this.floodFillSmallOcean(explored, index, region);
            }
        }
    }

    private void floodFillSmallOcean(BitSet explored, int index, Region region) {
        IntOpenHashSet values = new IntOpenHashSet();
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        queue.enqueue(index);
        values.add(index);
        boolean unbounded = false;
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    int next = region.offset(last, dx, dz);
                    if (next == -1) {
                        unbounded = true;
                        continue;
                    }
                    Region.Point point = region.data()[next];
                    if (point == null) {
                        unbounded = true;
                        continue;
                    }
                    if (point.land() || explored.get(next)) continue;
                    explored.set(next);
                    queue.enqueue(next);
                    values.add(next);
                }
            }
        }
        if (values.size() < 180 && !unbounded) {
            values.forEach(i -> region.data()[i].setLand());
        }
    }
}

