/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;

public enum ChooseBiomes implements RegionTask
{
    INSTANCE;

    private static final int[] MOUNTAIN_ALTITUDE_BIOMES;
    private static final int[] OCEANIC_MOUNTAIN_ALTITUDE_BIOMES;
    private static final int[][] ALTITUDE_BIOMES;
    private static final int[] ISLAND_BIOMES;
    private static final int[] MID_DEPTH_OCEAN_BIOMES;

    @Override
    public void apply(RegionGenerator.Context context) {
        Region region = context.region;
        Area blobArea = context.generator().biomeArea.get();
        long rngSeed = context.random.m_188505_();
        long climateSeed = context.random.m_188505_();
        for (int x = region.minX(); x <= region.maxX(); ++x) {
            for (int z = region.minZ(); z <= region.maxZ(); ++z) {
                float maxRainfallForBadlands;
                Region.Point point = region.maybeAt(x, z);
                if (point == null) continue;
                int areaSeed = blobArea.get(x, z);
                point.biome = point.island() ? this.randomSeededFrom(rngSeed, areaSeed, ISLAND_BIOMES) : (point.mountain() ? this.randomSeededFrom(rngSeed, areaSeed, point.coastalMountain() ? OCEANIC_MOUNTAIN_ALTITUDE_BIOMES : MOUNTAIN_ALTITUDE_BIOMES) : (point.land() ? this.randomSeededFrom(rngSeed, areaSeed, ALTITUDE_BIOMES[point.discreteBiomeAltitude()]) : (point.baseOceanDepth < 3 ? TFCLayers.OCEAN : (point.baseOceanDepth > 9 ? TFCLayers.DEEP_OCEAN_TRENCH : (point.baseOceanDepth >= 5 || point.distanceToEdge < 2 ? TFCLayers.DEEP_OCEAN : this.randomSeededFrom(rngSeed, areaSeed, MID_DEPTH_OCEAN_BIOMES))))));
                float minRainForLowFreshWaterBiomes = 90.0f + (float)Math.floorMod((long)areaSeed ^ climateSeed, 40);
                if (point.rainfall < minRainForLowFreshWaterBiomes) {
                    if (point.biome == TFCLayers.LOWLANDS) {
                        point.biome = TFCLayers.PLAINS;
                    } else if (point.biome == TFCLayers.LOW_CANYONS) {
                        point.biome = TFCLayers.CANYONS;
                    }
                }
                if (!(point.rainfall > (maxRainfallForBadlands = 420.0f + (float)Math.floorMod((long)areaSeed ^ climateSeed, 40)))) continue;
                if (point.biome == TFCLayers.BADLANDS) {
                    point.biome = TFCLayers.HIGHLANDS;
                    continue;
                }
                if (point.biome != TFCLayers.INVERTED_BADLANDS) continue;
                point.biome = TFCLayers.ROLLING_HILLS;
            }
        }
    }

    private int randomSeededFrom(long rngSeed, int areaSeed, int[] choices) {
        return choices[Math.floorMod(rngSeed ^ (long)areaSeed, choices.length)];
    }

    static {
        MOUNTAIN_ALTITUDE_BIOMES = new int[]{TFCLayers.MOUNTAINS, TFCLayers.MOUNTAINS, TFCLayers.MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS, TFCLayers.PLATEAU, TFCLayers.HIGHLANDS};
        OCEANIC_MOUNTAIN_ALTITUDE_BIOMES = new int[]{TFCLayers.VOLCANIC_MOUNTAINS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.OCEANIC_MOUNTAINS, TFCLayers.OCEANIC_MOUNTAINS, TFCLayers.ROLLING_HILLS};
        ALTITUDE_BIOMES = new int[][]{{TFCLayers.PLAINS, TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.LOW_CANYONS, TFCLayers.LOWLANDS, TFCLayers.LOWLANDS}, {TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.HIGHLANDS, TFCLayers.INVERTED_BADLANDS, TFCLayers.BADLANDS, TFCLayers.PLATEAU, TFCLayers.CANYONS, TFCLayers.LOW_CANYONS}, {TFCLayers.HIGHLANDS, TFCLayers.HIGHLANDS, TFCLayers.HIGHLANDS, TFCLayers.ROLLING_HILLS, TFCLayers.BADLANDS, TFCLayers.PLATEAU, TFCLayers.PLATEAU, TFCLayers.OLD_MOUNTAINS, TFCLayers.OLD_MOUNTAINS}};
        ISLAND_BIOMES = new int[]{TFCLayers.PLAINS, TFCLayers.HILLS, TFCLayers.ROLLING_HILLS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS, TFCLayers.VOLCANIC_OCEANIC_MOUNTAINS};
        MID_DEPTH_OCEAN_BIOMES = new int[]{TFCLayers.DEEP_OCEAN, TFCLayers.OCEAN, TFCLayers.OCEAN, TFCLayers.OCEAN_REEF, TFCLayers.OCEAN_REEF, TFCLayers.OCEAN_REEF};
    }
}

