/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.region;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.BitSet;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionTask;
import net.minecraft.util.RandomSource;

public enum AnnotateBiomeAltitude implements RegionTask
{
    INSTANCE;

    public static final int WIDTH = 4;

    @Override
    public void apply(RegionGenerator.Context context) {
        int index;
        int dx;
        Region region = context.region;
        RandomSource random = context.random;
        BitSet explored = new BitSet(region.sizeX() * region.sizeZ());
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        for (dx = 0; dx < region.sizeX(); ++dx) {
            for (int dz = 0; dz < region.sizeZ(); ++dz) {
                index = dx + region.sizeX() * dz;
                Region.Point point = region.data()[index];
                if (point == null || !point.land() || !point.mountain()) continue;
                point.biomeAltitude = (byte)12;
                queue.enqueue(index);
                explored.set(index);
            }
        }
        while (!queue.isEmpty()) {
            int last = queue.dequeueInt();
            Region.Point lastPoint = region.data()[last];
            int nextAltitude = lastPoint.biomeAltitude - 1;
            if (nextAltitude < 0) continue;
            for (int dx2 = -1; dx2 <= 1; ++dx2) {
                for (int dz = -1; dz <= 1; ++dz) {
                    int next = region.offset(last, dx2, dz);
                    if (next == -1) continue;
                    Region.Point point = region.data()[next];
                    if (point != null && point.land() && point.biomeAltitude == 0 && !explored.get(next)) {
                        if (random.m_188503_(13) == 0 && lastPoint.biomeAltitude != 12) {
                            point.biomeAltitude = lastPoint.biomeAltitude;
                            queue.enqueueFirst(next);
                        } else {
                            point.biomeAltitude = (byte)nextAltitude;
                            queue.enqueue(next);
                        }
                    }
                    explored.set(next);
                }
            }
        }
        for (dx = 0; dx < region.sizeX(); ++dx) {
            for (int dz = 0; dz < region.sizeZ(); ++dz) {
                index = dx + region.sizeX() * dz;
                Region.Point point = region.data()[index];
                if (point == null || !point.land() || point.discreteBiomeAltitude() != 0 || point.baseLandHeight < 4) continue;
                if (point.discreteBiomeAltitude() == 0 && point.baseLandHeight >= 4) {
                    point.biomeAltitude = (byte)4;
                }
                if (point.discreteBiomeAltitude() != 1 || point.baseLandHeight < 11) continue;
                point.biomeAltitude = (byte)8;
            }
        }
    }
}

