/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.biome.VolcanoNoise;
import net.dries007.tfc.world.placement.TFCPlacements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class VolcanoPlacement
extends PlacementModifier {
    public static final Codec<VolcanoPlacement> PLACEMENT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("center", (Object)false).forGetter(c -> c.center), (App)Codecs.UNIT_FLOAT.optionalFieldOf("distance", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.distance))).apply((Applicative)instance, VolcanoPlacement::new));
    private final boolean center;
    private final float distance;
    private final ThreadLocal<LocalContext> localContext;

    public VolcanoPlacement(boolean center, float distance) {
        this.center = center;
        this.distance = distance;
        this.localContext = ThreadLocal.withInitial(() -> null);
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)TFCPlacements.VOLCANO.get();
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        Biome biome;
        BiomeExtension variants;
        WorldGenLevel level = context.m_191831_();
        long seed = level.m_7328_();
        LocalContext local = this.localContext.get();
        if (local == null || local.seed != seed) {
            local = new LocalContext(seed, new VolcanoNoise(seed));
            this.localContext.set(local);
        }
        if ((variants = TFCBiomes.getExtensionOrThrow((LevelAccessor)level, biome = (Biome)level.m_204166_(pos).m_203334_())).isVolcanic()) {
            if (this.center) {
                BlockPos center = local.volcanoNoise.calculateCenter(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), variants.getVolcanoRarity());
                if (center != null) {
                    WorldGenRegion generating;
                    if (level instanceof WorldGenRegion && !this.ensureCanWrite(generating = (WorldGenRegion)level, center)) {
                        return Stream.empty();
                    }
                    return Stream.of(center);
                }
            } else if (local.volcanoNoise.calculateEasing(pos.m_123341_(), pos.m_123343_(), variants.getVolcanoRarity()) > this.distance) {
                return Stream.of(pos);
            }
        }
        return Stream.empty();
    }

    private boolean ensureCanWrite(WorldGenRegion level, BlockPos pos) {
        int xSection = SectionPos.m_123171_((int)pos.m_123341_());
        int zSection = SectionPos.m_123171_((int)pos.m_123343_());
        ChunkPos chunkpos = level.m_143488_();
        return chunkpos.f_45578_ == xSection && chunkpos.f_45579_ == zSection;
    }

    record LocalContext(long seed, VolcanoNoise volcanoNoise) {
    }
}

