/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.util.Helpers;
import net.minecraft.util.RandomSource;

public class Metaballs3D {
    private final Ball[] balls;

    public static Metaballs3D simple(RandomSource random, int size) {
        return new Metaballs3D(random, 5, 7, 0.1f * (float)size, 0.3f * (float)size, 0.5f * (float)size);
    }

    public Metaballs3D(RandomSource random, int minBalls, int maxBalls, double minSize, double maxSize, double radius) {
        int ballCount = Helpers.uniform(random, minBalls, maxBalls);
        int negativeBallCount = minSize < 0.0 ? (int)((double)ballCount * (-minSize / (maxSize - minSize))) : 0;
        this.balls = new Ball[ballCount];
        for (int i = 0; i < this.balls.length; ++i) {
            this.balls[i] = new Ball(Helpers.triangle(random, radius), Helpers.triangle(random, radius), Helpers.triangle(random, radius), i < negativeBallCount ? Helpers.uniform(random, minSize, 0.0) : Helpers.uniform(random, 0.0, maxSize));
        }
    }

    public boolean inside(double x, double y, double z) {
        double f = 0.0;
        for (Ball ball : this.balls) {
            if (!((f += ball.weight * Math.abs(ball.weight) / ((x - ball.x) * (x - ball.x) + (y - ball.y) * (y - ball.y) + (z - ball.z) * (z - ball.z))) > 1.0)) continue;
            return true;
        }
        return false;
    }

    record Ball(double x, double y, double z, double weight) {
    }
}

