/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import java.util.function.ToDoubleBiFunction;

public record Kernel(double[] values, int radius) {
    public static Kernel create(ToDoubleBiFunction<Integer, Integer> func, int radius) {
        int size = radius * 2 + 1;
        double[] array = new double[size * size];
        double sum = 0.0;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                double value = func.applyAsDouble(x - radius, z - radius);
                assert (value >= 0.0) : "Invalid kernel value: " + value + " for x = " + x + ", z = " + z;
                array[x + z * size] = value;
                sum += value;
            }
        }
        assert (0.99 < sum && sum < 1.01) : "Invalid kernel sum: " + sum + " is not ~= 1.00";
        return new Kernel(array, radius);
    }

    public int width() {
        return 2 * this.radius + 1;
    }
}

