/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.vein.IVein;
import net.dries007.tfc.world.feature.vein.IVeinConfig;
import net.dries007.tfc.world.feature.vein.Indicator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class VeinFeature<C extends IVeinConfig, V extends IVein>
extends Feature<C> {
    private static final int MAX_VEIN_Y_NO_ORE_PLACED = Integer.MIN_VALUE;

    public VeinFeature(Codec<C> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<C> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        IVeinConfig config = (IVeinConfig)context.m_159778_();
        WorldGenerationContext generationContext = new WorldGenerationContext(context.m_159775_(), (LevelHeightAccessor)level);
        ChunkPos chunkPos = new ChunkPos(pos);
        List<V> veins = this.getNearbyVeins(level, generationContext, chunkPos, config.chunkRadius(), config, arg_0 -> ((WorldGenLevel)level).m_204166_(arg_0));
        if (!veins.isEmpty()) {
            for (IVein vein : veins) {
                this.place(level, random, chunkPos.m_45604_(), chunkPos.m_45605_(), vein, config);
            }
            return true;
        }
        return false;
    }

    public final List<V> getNearbyVeins(WorldGenLevel level, WorldGenerationContext context, ChunkPos pos, int radius, C config, Function<BlockPos, Holder<Biome>> biomeQuery) {
        ArrayList veins = new ArrayList();
        for (int x = pos.f_45578_ - radius; x <= pos.f_45578_ + radius; ++x) {
            for (int z = pos.f_45579_ - radius; z <= pos.f_45579_ + radius; ++z) {
                this.getVeinsAtChunk(level, context, x, z, veins, config, biomeQuery);
            }
        }
        return veins;
    }

    public final void getVeinsAtChunk(WorldGenLevel level, WorldGenerationContext context, int chunkPosX, int chunkPosZ, List<V> veins, C config, Function<BlockPos, Holder<Biome>> biomeQuery) {
        V vein;
        XoroshiroRandomSource random = new XoroshiroRandomSource(level.m_7328_() ^ (long)chunkPosX * 61728364132L, config.config().seed() ^ (long)chunkPosZ * 16298364123L);
        if (random.m_188503_(config.config().rarity()) == 0 && config.canSpawnAt((vein = this.createVein(context, chunkPosX << 4, chunkPosZ << 4, (RandomSource)random, config)).pos(), biomeQuery)) {
            veins.add(vein);
        }
    }

    protected void place(WorldGenLevel level, RandomSource random, int blockX, int blockZ, V vein, C config) {
        int offsetZ;
        int offsetX;
        boolean debugIndicatorLocations = false;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockPos pos = vein.pos();
        BoundingBox box = this.getBoundingBox(config, vein).m_71045_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        if (config.config().projectOffset()) {
            XoroshiroRandomSource offsetRandom = new XoroshiroRandomSource((long)Helpers.hash(182739412341L, pos));
            offsetX = offsetRandom.m_188503_(16) - offsetRandom.m_188503_(16);
            offsetZ = offsetRandom.m_188503_(16) - offsetRandom.m_188503_(16);
        } else {
            offsetZ = 0;
            offsetX = 0;
        }
        int minX = Math.max(blockX, box.m_162395_());
        int maxX = Math.min(blockX + 15, box.m_162399_());
        int minY = Math.max(config.minY(), box.m_162396_());
        int maxY = Math.min(config.maxY(), box.m_162400_());
        int minZ = Math.max(blockZ, box.m_162398_());
        int maxZ = Math.min(blockZ + 15, box.m_162401_());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int indicatorZ;
                int indicatorX;
                int indicatorY;
                int projectedY;
                int maxVeinY = Integer.MIN_VALUE;
                int n = projectedY = config.config().projectToSurface() ? level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, offsetX + x, offsetZ + z) : 0;
                if (config.config().nearLava() && !this.isNearLava(level, cursor, x, z)) continue;
                for (int y = minY; y <= maxY; ++y) {
                    if (!(random.m_188501_() < this.getChanceToGenerate(x - pos.m_123341_(), y - pos.m_123342_(), z - pos.m_123343_(), vein, config))) continue;
                    cursor.m_122178_(x, y + projectedY, z);
                    BlockState stoneState = level.m_8055_((BlockPos)cursor);
                    BlockState oreState = this.getStateToGenerate(stoneState, random, config, x - pos.m_123341_(), y - pos.m_123342_(), z - pos.m_123343_());
                    if (oreState == null) continue;
                    level.m_7731_((BlockPos)cursor, oreState, 3);
                    maxVeinY = y + projectedY;
                }
                Indicator indicator = config.indicator();
                if (indicator == null || maxVeinY == Integer.MIN_VALUE) continue;
                if (indicator.rarity() > 0 && random.m_188503_(indicator.rarity()) == 0 && Math.abs((indicatorY = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, indicatorX = x + random.m_188503_(15) - random.m_188503_(15), indicatorZ = z + random.m_188503_(15) - random.m_188503_(15))) - maxVeinY) < indicator.depth()) {
                    cursor.m_122178_(indicatorX, indicatorY, indicatorZ);
                    BlockState stateAt = level.m_8055_((BlockPos)cursor);
                    BlockState state = FluidHelpers.fillWithFluid(indicator.getStateToGenerate(random), stateAt.m_60819_().m_76152_());
                    if (state != null && EnvironmentHelpers.isWorldgenReplaceable(stateAt) && state.m_60710_((LevelReader)level, (BlockPos)cursor)) {
                        level.m_7731_((BlockPos)cursor, state, 3);
                    }
                }
                for (int i = 0; i < indicator.undergroundCount(); ++i) {
                    int indicatorZ2;
                    int maxGroundY;
                    if (indicator.undergroundRarity() != 1 && random.m_188503_(indicator.undergroundRarity()) != 0) continue;
                    int indicatorX2 = x + random.m_188503_(15) - random.m_188503_(15);
                    indicatorY = minY + (maxY > minY ? random.m_188503_(maxY - minY) : 0) + random.m_188503_(32) - random.m_188503_(8);
                    if (indicatorY > (maxGroundY = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, indicatorX2, indicatorZ2 = z + random.m_188503_(15) - random.m_188503_(15))) - 5) continue;
                    cursor.m_122178_(indicatorX2, indicatorY, indicatorZ2);
                    BlockState stateAt = level.m_8055_((BlockPos)cursor);
                    BlockState state = FluidHelpers.fillWithFluid(indicator.getStateToGenerate(random), stateAt.m_60819_().m_76152_());
                    if (state == null || !EnvironmentHelpers.isWorldgenReplaceable(stateAt) || !state.m_60710_((LevelReader)level, (BlockPos)cursor)) continue;
                    level.m_7731_((BlockPos)cursor, state, 3);
                }
            }
        }
    }

    @Nullable
    protected BlockState getStateToGenerate(BlockState stoneState, RandomSource random, C config, int x, int y, int z) {
        return config.getStateToGenerate(stoneState, random);
    }

    protected final BlockPos defaultPos(int chunkX, int chunkZ, RandomSource random, C config) {
        return new BlockPos(chunkX + random.m_188503_(16), this.defaultYPos(config.verticalRadius(), random, config), chunkZ + random.m_188503_(16));
    }

    protected final int defaultYPos(int verticalShrinkRange, RandomSource random, C config) {
        int actualRange = config.maxY() - config.minY() - 2 * verticalShrinkRange;
        if (actualRange > 0) {
            return config.minY() + verticalShrinkRange + random.m_188503_(actualRange);
        }
        return (config.minY() + config.maxY()) / 2;
    }

    protected abstract float getChanceToGenerate(int var1, int var2, int var3, V var4, C var5);

    protected abstract V createVein(WorldGenerationContext var1, int var2, int var3, RandomSource var4, C var5);

    protected abstract BoundingBox getBoundingBox(C var1, V var2);

    private boolean isNearLava(WorldGenLevel level, BlockPos.MutableBlockPos cursor, int x, int z) {
        int lavaY = -55;
        for (int lavaX = x - 4; lavaX <= x + 4; ++lavaX) {
            for (int lavaZ = z - 4; lavaZ <= z + 4; ++lavaZ) {
                cursor.m_122178_(lavaX, -55, lavaZ);
                if (level.m_6425_((BlockPos)cursor).m_76152_() != Fluids.f_76195_) continue;
                return true;
            }
        }
        return false;
    }
}

