/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.plant.KrummholzBlock;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.tree.KrummholzConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraftforge.common.Tags;

public class KrummholzFeature
extends Feature<KrummholzConfig> {
    public KrummholzFeature(Codec<KrummholzConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<KrummholzConfig> context) {
        int i;
        KrummholzConfig config = (KrummholzConfig)context.m_159778_();
        BlockState block = config.block().m_49966_();
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        int height = config.height().m_214085_(context.m_225041_());
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        cursor.m_122154_((Vec3i)pos, 0, -1, 0);
        BlockState below = level.m_8055_((BlockPos)cursor);
        boolean validBlock = Helpers.isBlock(below, TFCTags.Blocks.TREE_GROWS_ON);
        if (config.spawnsOnStone()) {
            validBlock |= Helpers.isBlock(below, (TagKey<Block>)Tags.Blocks.STONE);
        }
        if (config.spawnsOnGravel()) {
            validBlock |= Helpers.isBlock(below, (TagKey<Block>)Tags.Blocks.GRAVEL);
        }
        if (!validBlock) {
            return false;
        }
        cursor.m_122184_(0, 1, 0);
        if (!block.m_60710_((LevelReader)level, pos) || !level.m_6425_(pos).m_76178_()) {
            return false;
        }
        int maxHeight = 1;
        for (i = 0; i < height; ++i) {
            cursor.m_122154_((Vec3i)pos, 0, i, 0);
            maxHeight = i + 1;
            if (!EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)cursor)) break;
        }
        for (i = 0; i < maxHeight; ++i) {
            BlockState newState;
            cursor.m_122154_((Vec3i)pos, 0, i, 0);
            BlockState blockState = newState = i == maxHeight - 1 ? Helpers.setProperty(block, KrummholzBlock.TIP, true) : block;
            if (i == 0) {
                newState = Helpers.setProperty(newState, KrummholzBlock.BOTTOM, true);
            }
            level.m_7731_((BlockPos)cursor, newState, 2);
        }
        return true;
    }
}

