/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.placement.ClimatePlacement;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public record ForestConfig(HolderSet<ConfiguredFeature<?, ?>> entries, Map<ForestType, Type> typeMap, boolean useWeirdness) implements FeatureConfiguration
{
    public static final Codec<ForestConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_203982_((Codec)ConfiguredFeature.f_65375_).fieldOf("entries").forGetter(c -> c.entries), (App)Codec.unboundedMap(ForestType.CODEC, Type.CODEC).fieldOf("types").forGetter(c -> c.typeMap), (App)Codecs.optionalFieldOf(Codec.BOOL, "use_weirdness", true).forGetter(c -> c.useWeirdness)).apply((Applicative)instance, ForestConfig::new));

    public record Type(IntProvider treeCount, IntProvider groundcoverCount, float perChunkChance, Optional<IntProvider> bushCount, boolean hasSpoilers, boolean allowOldGrowth, IntProvider leafPileCount) {
        public static final Codec<Type> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.optionalFieldOf(IntProvider.f_146531_, "tree_count", UniformInt.m_146622_((int)0, (int)0)).forGetter(c -> c.treeCount), (App)Codecs.optionalFieldOf(IntProvider.f_146531_, "groundcover_count", UniformInt.m_146622_((int)0, (int)0)).forGetter(c -> c.groundcoverCount), (App)Codecs.optionalFieldOf(Codec.FLOAT, "per_chunk_chance", Float.valueOf(1.0f)).forGetter(c -> Float.valueOf(c.perChunkChance)), (App)Codecs.optionalFieldOf(IntProvider.f_146531_, "bush_count").forGetter(c -> c.bushCount), (App)Codecs.optionalFieldOf(Codec.BOOL, "has_spoiler_old_growth", false).forGetter(c -> c.hasSpoilers), (App)Codecs.optionalFieldOf(Codec.BOOL, "allows_old_growth", false).forGetter(c -> c.allowOldGrowth), (App)Codecs.optionalFieldOf(IntProvider.f_146531_, "leaf_pile_count", UniformInt.m_146622_((int)0, (int)0)).forGetter(c -> c.leafPileCount)).apply((Applicative)instance, Type::new));

        public int sampleBushCount(RandomSource random, Optional<IntProvider> count, int treeCount, float density) {
            return count.map(sampler -> sampler.m_214085_(random)).orElse((int)((float)treeCount * density));
        }
    }

    public record Entry(ClimatePlacement climate, Optional<BlockState> bushLog, Optional<BlockState> bushLeaves, Optional<BlockState> fallenLog, Optional<BlockState> fallenLeaves, Optional<IWeighted<BlockState>> groundcover, Holder<ConfiguredFeature<?, ?>> treeFeature, Holder<ConfiguredFeature<?, ?>> deadFeature, Optional<Holder<ConfiguredFeature<?, ?>>> oldGrowthFeature, Optional<Holder<ConfiguredFeature<?, ?>>> krummholz, int oldGrowthChance, int spoilerOldGrowthChance, int fallenChance, int deadChance, boolean floating) implements FeatureConfiguration
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ClimatePlacement.PLACEMENT_CODEC.fieldOf("climate").forGetter(c -> c.climate), (App)Codecs.optionalFieldOf(Codecs.BLOCK_STATE, "bush_log").forGetter(c -> c.bushLog), (App)Codecs.optionalFieldOf(Codecs.BLOCK_STATE, "bush_leaves").forGetter(c -> c.bushLeaves), (App)Codecs.optionalFieldOf(Codecs.BLOCK_STATE, "fallen_log").forGetter(c -> c.fallenLog), (App)Codecs.optionalFieldOf(Codecs.BLOCK_STATE, "fallen_leaves").forGetter(c -> c.fallenLeaves), (App)Codecs.optionalFieldOf(Codecs.weightedCodec(Codecs.BLOCK_STATE, "block"), "groundcover").forGetter(c -> c.groundcover), (App)ConfiguredFeature.f_65374_.fieldOf("normal_tree").forGetter(c -> c.treeFeature), (App)ConfiguredFeature.f_65374_.fieldOf("dead_tree").forGetter(c -> c.deadFeature), (App)Codecs.optionalFieldOf(ConfiguredFeature.f_65374_, "old_growth_tree").forGetter(c -> c.oldGrowthFeature), (App)Codecs.optionalFieldOf(ConfiguredFeature.f_65374_, "krummholz").forGetter(c -> c.oldGrowthFeature), (App)Codecs.optionalFieldOf(Codec.INT, "old_growth_chance", 6).forGetter(c -> c.oldGrowthChance), (App)Codecs.optionalFieldOf(Codec.INT, "spoiler_old_growth_chance", 200).forGetter(c -> c.spoilerOldGrowthChance), (App)Codecs.optionalFieldOf(Codec.INT, "fallen_tree_chance", 14).forGetter(c -> c.fallenChance), (App)Codecs.optionalFieldOf(Codec.INT, "dead_chance", 75).forGetter(c -> c.deadChance), (App)Codecs.optionalFieldOf(Codec.BOOL, "floating", false).forGetter(c -> c.floating)).apply((Applicative)instance, Entry::new));

        public boolean isValid(float temperature, float rainfall) {
            return rainfall >= this.climate.getMinRainfall() && rainfall <= this.climate.getMaxRainfall() && temperature >= this.climate.getMinTemp() && temperature <= this.climate.getMaxTemp();
        }

        public float distanceFromMean(float temperature, float rainfall) {
            return (rainfall + temperature - this.getAverageTemp() - this.getAverageRain()) / 2.0f;
        }

        public float getAverageTemp() {
            return (this.climate.getMaxTemp() - this.climate.getMinTemp()) / 2.0f;
        }

        public float getAverageRain() {
            return (this.climate.getMaxRainfall() - this.climate.getMinRainfall()) / 2.0f;
        }

        public ConfiguredFeature<?, ?> getFeature() {
            return (ConfiguredFeature)this.treeFeature.m_203334_();
        }

        public ConfiguredFeature<?, ?> getDeadFeature() {
            return (ConfiguredFeature)this.deadFeature.m_203334_();
        }

        public ConfiguredFeature<?, ?> getOldGrowthFeature() {
            return (ConfiguredFeature)this.oldGrowthFeature.orElse(this.treeFeature).m_203334_();
        }
    }
}

