/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.plant;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.plant.KelpTreeFlowerBlock;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingCaneBlock;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.world.feature.BlockConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SpreadingBushFeature
extends Feature<BlockConfig<SpreadingBushBlock>> {
    public static final Codec<BlockConfig<SpreadingBushBlock>> CODEC = BlockConfig.codec(b -> {
        SpreadingBushBlock t;
        return b instanceof SpreadingBushBlock ? (t = (SpreadingBushBlock)b) : null;
    }, "Must be a " + KelpTreeFlowerBlock.class.getSimpleName());

    public SpreadingBushFeature(Codec<BlockConfig<SpreadingBushBlock>> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockConfig<SpreadingBushBlock>> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        SpreadingBushBlock block = (SpreadingBushBlock)((BlockConfig)context.m_159778_()).block();
        boolean any = false;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int tries = 0; tries < 5; ++tries) {
            cursor.m_122154_((Vec3i)pos, random.m_188503_(3) - random.m_188503_(3), random.m_188503_(2) - random.m_188503_(2), random.m_188503_(3) - random.m_188503_(3));
            BlockState stateToPlace = block.m_49966_();
            if (!block.m_7898_(stateToPlace, (LevelReader)level, (BlockPos)cursor) || level.m_8055_(cursor.m_7495_()).m_60734_() == block) continue;
            int height = 1 + random.m_188503_(3);
            for (int i = 0; i < height && EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)cursor); ++i) {
                any = true;
                int stage = height - i - 1;
                level.m_7731_((BlockPos)cursor, (BlockState)stateToPlace.m_61124_((Property)SpreadingBushBlock.STAGE, (Comparable)Integer.valueOf(stage)), 2);
                Direction offset = Direction.Plane.HORIZONTAL.m_235690_(random);
                cursor.m_122173_(offset);
                if (stage > 0 && EnvironmentHelpers.isWorldgenReplaceable(level, (BlockPos)cursor)) {
                    level.m_7731_((BlockPos)cursor, (BlockState)block.getCane().m_49966_().m_61124_((Property)SpreadingCaneBlock.FACING, (Comparable)offset), 2);
                }
                cursor.m_122173_(offset.m_122424_());
                cursor.m_122173_(Direction.UP);
            }
        }
        return any;
    }
}

