/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.cave;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.ThinSpikeBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.feature.cave.ThinSpikeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ThinSpikeFeature
extends Feature<ThinSpikeConfig> {
    public ThinSpikeFeature(Codec<ThinSpikeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ThinSpikeConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource rand = context.m_225041_();
        ThinSpikeConfig config = (ThinSpikeConfig)context.m_159778_();
        BlockState spike = config.state();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        boolean placedAny = false;
        for (int attempt = 0; attempt < config.tries(); ++attempt) {
            mutablePos.m_122154_((Vec3i)pos, rand.m_188503_(config.radius()) - rand.m_188503_(config.radius()), rand.m_188503_(config.radius() - rand.m_188503_(config.radius())), rand.m_188503_(config.radius()) - rand.m_188503_(config.radius()));
            for (int i = 0; i < 7; ++i) {
                mutablePos.m_122184_(0, 1, 0);
                if (FluidHelpers.isAirOrEmptyFluid(level.m_8055_((BlockPos)mutablePos))) continue;
                mutablePos.m_122184_(0, -1, 0);
                break;
            }
            placedAny |= this.placeSpike(level, mutablePos, spike, rand, config);
        }
        return placedAny;
    }

    private boolean placeSpike(WorldGenLevel level, BlockPos.MutableBlockPos pos, BlockState spike, RandomSource random, ThinSpikeConfig config) {
        BlockState lastState;
        pos.m_122184_(0, 1, 0);
        BlockState stateAbove = level.m_8055_((BlockPos)pos);
        if (Helpers.isBlock(stateAbove, spike.m_60734_())) {
            return false;
        }
        pos.m_122184_(0, -1, 0);
        if (!this.placeSpikeBlock(level, (BlockPos)pos, spike)) {
            return false;
        }
        int height = config.getHeight(random);
        for (int i = 0; i < height; ++i) {
            pos.m_122184_(0, -1, 0);
            if (this.placeSpikeBlock(level, (BlockPos)pos, spike)) continue;
            pos.m_122184_(0, 1, 0);
            break;
        }
        if ((lastState = level.m_8055_((BlockPos)pos)).m_60734_() == spike.m_60734_()) {
            lastState = (BlockState)lastState.m_61124_((Property)ThinSpikeBlock.TIP, (Comparable)Boolean.valueOf(true));
            level.m_7731_((BlockPos)pos, lastState, 2);
            return true;
        }
        return false;
    }

    private boolean placeSpikeBlock(WorldGenLevel level, BlockPos pos, BlockState spike) {
        BlockState adjustedSpike;
        BlockState state = level.m_8055_(pos);
        if (FluidHelpers.isAirOrEmptyFluid(state) && spike.m_60710_((LevelReader)level, pos) && (adjustedSpike = FluidHelpers.fillWithFluid(spike, state.m_60819_().m_76152_())) != null) {
            level.m_7731_(pos, adjustedSpike, 2);
            return true;
        }
        return false;
    }
}

