/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.Codecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public record FissureConfig(Optional<BlockState> wallState, BlockState fluidState, int count, int radius, VerticalAnchor minDepth, int minPieces, int maxPieces, int maxPieceLength, Optional<Decoration> decoration) implements FeatureConfiguration
{
    public static final Codec<FissureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.optionalFieldOf(Codecs.BLOCK_STATE, "wall_state").forGetter(c -> c.wallState), (App)Codecs.BLOCK_STATE.fieldOf("fluid_state").forGetter(c -> c.fluidState), (App)Codecs.f_144629_.optionalFieldOf("count", (Object)5).forGetter(c -> c.count), (App)Codecs.f_144629_.optionalFieldOf("radius", (Object)12).forGetter(c -> c.radius), (App)Codecs.optionalFieldOf(VerticalAnchor.f_158914_, "min_depth", VerticalAnchor.m_158930_((int)16)).forGetter(c -> c.minDepth), (App)Codecs.f_144629_.optionalFieldOf("min_pieces", (Object)10).forGetter(c -> c.minPieces), (App)Codecs.f_144629_.optionalFieldOf("max_pieces", (Object)24).forGetter(c -> c.maxPieces), (App)Codecs.f_144629_.optionalFieldOf("max_piece_length", (Object)6).forGetter(c -> c.maxPieceLength), (App)Codecs.optionalFieldOf(Decoration.CODEC, "decoration").forGetter(c -> c.decoration)).apply((Applicative)instance, FissureConfig::new));

    public record Decoration(Map<Block, IWeighted<BlockState>> states, int rarity, int radius, int count) {
        public static final Codec<Decoration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.BLOCK_TO_WEIGHTED_BLOCKSTATE.fieldOf("blocks").forGetter(c -> c.states), (App)Codecs.f_144629_.fieldOf("rarity").forGetter(c -> c.rarity), (App)Codecs.f_144629_.fieldOf("radius").forGetter(c -> c.radius), (App)Codecs.f_144629_.fieldOf("count").forGetter(c -> c.count)).apply((Applicative)instance, Decoration::new));

        @Nullable
        public BlockState getState(BlockState stoneState, RandomSource random) {
            IWeighted<BlockState> weighted = this.states.get(stoneState.m_60734_());
            if (weighted != null) {
                return weighted.get(random);
            }
            return null;
        }
    }
}

