/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.entities.misc.TFCFallingBlockEntity;
import net.dries007.tfc.common.recipes.LandslideRecipe;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.MutableDensityFunctionContext;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.chunkdata.RockData;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ErosionFeature
extends Feature<NoneFeatureConfiguration> {
    public ErosionFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        ChunkAccess chunk = level.m_46865_(pos);
        ChunkPos chunkPos = new ChunkPos(pos);
        int chunkX = chunkPos.m_45604_();
        int chunkZ = chunkPos.m_45605_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        RockData rockData = ChunkDataProvider.get(context.m_159775_()).get(chunk).getRockData();
        ChunkGeneratorExtension extension = (ChunkGeneratorExtension)context.m_159775_();
        RockLayerSettings rockSettings = extension.rockLayerSettings();
        Aquifer aquifer = extension.getOrCreateAquifer(chunk);
        MutableDensityFunctionContext point = new MutableDensityFunctionContext(mutablePos);
        int minY = context.m_159775_().m_142062_();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int baseHeight = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, chunkX + x, chunkZ + z);
                boolean prevBlockCanLandslide = false;
                int lastSafeY = baseHeight;
                Block prevBlockHardened = null;
                mutablePos.m_122178_(chunkX + x, baseHeight, chunkZ + z);
                for (int y = baseHeight; y >= minY; --y) {
                    boolean stateAtIsFragile;
                    mutablePos.m_142448_(y);
                    BlockState stateAt = chunk.m_8055_((BlockPos)mutablePos);
                    LandslideRecipe recipe = stateAt.m_60795_() ? null : LandslideRecipe.getRecipe(stateAt);
                    boolean bl = stateAtIsFragile = stateAt.m_60795_() || TFCFallingBlockEntity.canFallThrough((BlockGetter)level, (BlockPos)mutablePos, stateAt);
                    if (prevBlockCanLandslide) {
                        if (recipe == null) {
                            if (stateAtIsFragile) {
                                if (lastSafeY > y + 2) {
                                    mutablePos.m_142448_(y + 1);
                                    this.setBlock(level, chunk, (BlockPos)mutablePos, rockData.getRock(chunkX + x, y + 1, chunkZ + z).hardened().m_49966_());
                                } else {
                                    mutablePos.m_142448_(y + 2);
                                    boolean blockAboveIsAir = chunk.m_8055_((BlockPos)mutablePos).m_60795_();
                                    mutablePos.m_142448_(y + 1);
                                    BlockState airOrLiquidState = aquifer.m_207104_((DensityFunction.FunctionContext)point, -1.0);
                                    if (blockAboveIsAir && airOrLiquidState != null) {
                                        this.setBlock(level, chunk, (BlockPos)mutablePos, airOrLiquidState);
                                    } else {
                                        mutablePos.m_142448_(y + 1);
                                        this.setBlock(level, chunk, (BlockPos)mutablePos, rockData.getRock(chunkX + x, y + 1, chunkZ + z).hardened().m_49966_());
                                    }
                                }
                            }
                            prevBlockCanLandslide = false;
                            lastSafeY = y;
                        }
                    } else if (recipe == null) {
                        lastSafeY = y;
                    } else {
                        prevBlockCanLandslide = true;
                    }
                    if (stateAtIsFragile) {
                        if (prevBlockHardened != null) {
                            mutablePos.m_142448_(y + 1);
                            this.setBlock(level, chunk, (BlockPos)mutablePos, prevBlockHardened.m_49966_());
                        }
                        prevBlockHardened = null;
                        continue;
                    }
                    prevBlockHardened = rockSettings.getHardened(stateAt.m_60734_());
                }
            }
        }
        return true;
    }

    private void setBlock(WorldGenLevel level, ChunkAccess chunk, BlockPos pos, BlockState state) {
        BlockState prevState = chunk.m_6978_(pos, state, false);
        if (prevState != null && prevState.m_155947_()) {
            chunk.m_8114_(pos);
        }
        if (state.m_60835_((BlockGetter)level, pos)) {
            chunk.m_8113_(pos);
        }
    }
}

