/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Spaghetti2D(DensityFunction rarityModulator, DensityFunction thicknessModulator, DensityFunction elevationModulator, DensityFunction.NoiseHolder noise) implements DensityFunction
{
    public static final KeyDispatchDataCodec<Spaghetti2D> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("rarity").forGetter(c -> c.rarityModulator), (App)DensityFunction.f_208218_.fieldOf("thickness").forGetter(c -> c.thicknessModulator), (App)DensityFunction.f_208218_.fieldOf("elevation").forGetter(c -> c.elevationModulator), (App)DensityFunction.NoiseHolder.f_223996_.fieldOf("noise").forGetter(c -> c.noise)).apply((Applicative)instance, Spaghetti2D::new)));

    public double m_207386_(DensityFunction.FunctionContext context) {
        double rarity = this.getRarity(this.rarityModulator.m_207386_(context));
        double rarityNoise = this.noise.m_224006_((double)context.m_207115_() / rarity, (double)context.m_207114_() / rarity, (double)context.m_207113_() / rarity);
        double thickness = this.thicknessModulator.m_207386_(context);
        double elevation = this.elevationModulator.m_207386_(context);
        double left = Math.abs(elevation - (double)context.m_207114_() / 8.0) - thickness;
        double right = Math.abs(rarity * rarityNoise) - 0.083 * thickness;
        return Mth.m_14008_((double)Math.max(left * left * left, right), (double)-1.0, (double)1.0);
    }

    public void m_207362_(double[] array, DensityFunction.ContextProvider context) {
        context.m_207207_(array, (DensityFunction)this);
    }

    public double m_207402_() {
        return -1.0;
    }

    public double m_207401_() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new Spaghetti2D(this.rarityModulator.m_207456_(visitor), this.thicknessModulator.m_207456_(visitor), this.elevationModulator.m_207456_(visitor), visitor.m_213918_(this.noise)));
    }

    private double getRarity(double value) {
        if (value < -0.75) {
            return 0.5;
        }
        if (value < -0.5) {
            return 0.75;
        }
        if (value < 0.5) {
            return 1.0;
        }
        return value < 0.75 ? 2.0 : 3.0;
    }
}

