/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import java.util.List;
import net.dries007.tfc.util.IArtist;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataGenerator;
import net.dries007.tfc.world.chunkdata.ChunkRockDataCache;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.chunkdata.LerpFloatLayer;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RiverEdge;
import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.jetbrains.annotations.Nullable;

public record RegionChunkDataGenerator(RegionGenerator regionGenerator, RockLayerSettings rockLayerSettings, ConcurrentArea<ForestType> forestTypeLayer, ThreadLocal<Area> rockLayerArea, Noise2D layerHeightNoise, Noise2D layerSkewXNoise, Noise2D layerSkewZNoise, Noise2D forestWeirdnessNoise, Noise2D forestDensityNoise) implements ChunkDataGenerator
{
    private static final int LAYER_OFFSET_BITS = 3;
    private static final int LAYER_OFFSET_MASK = 7;
    private static final int[] LAYER_OFFSETS = new int[16];
    private static final float DELTA_Y_OFFSET = 12.0f;
    private static final int MIN_RIVER_WIDTH = 12;
    private static final float RIVER_INFLUENCE = (float)Units.blockToGridExact(40.0);
    private static final float RIVER_INFLUENCE_SQ = RIVER_INFLUENCE * RIVER_INFLUENCE;

    private static int getOffsetX(int layer) {
        return LAYER_OFFSETS[(layer & 7) << 1];
    }

    private static int getOffsetZ(int layer) {
        return LAYER_OFFSETS[(layer & 7) << 1 | 1];
    }

    public static RegionChunkDataGenerator create(long worldSeed, RockLayerSettings rockLayerSettings, RegionGenerator regionGenerator) {
        XoroshiroRandomSource random = new XoroshiroRandomSource(worldSeed);
        random.m_188584_(worldSeed ^ random.m_188505_());
        ThreadLocal<Area> rockLayerArea = ThreadLocal.withInitial(TFCLayers.createOverworldRockLayer(regionGenerator, random.m_188505_()));
        OpenSimplex2D layerHeightNoise = new OpenSimplex2D(random.m_188502_()).octaves(3).scaled(43.0, 63.0).spread(0.014f);
        OpenSimplex2D layerSkewXNoise = new OpenSimplex2D(random.m_188502_()).octaves(2).scaled(-1.8f, 1.8f).spread(0.01f);
        OpenSimplex2D layerSkewZNoise = new OpenSimplex2D(random.m_188502_()).octaves(2).scaled(-1.8f, 1.8f).spread(0.01f);
        ConcurrentArea<ForestType> forestTypeLayer = new ConcurrentArea<ForestType>(TFCLayers.createOverworldForestLayer(random.m_188505_(), IArtist.nope()), ForestType::valueOf);
        Noise2D forestWeirdnessNoise = new OpenSimplex2D(random.m_188502_()).octaves(4).spread(0.0025f).map(x -> (double)1.1f * Math.abs(x)).clamped(0.0, 1.0);
        Noise2D forestDensityNoise = new OpenSimplex2D(random.m_188502_()).octaves(4).spread(0.0025f).scaled(-0.2f, 1.2f).clamped(0.0, 1.0);
        return new RegionChunkDataGenerator(regionGenerator, rockLayerSettings, forestTypeLayer, rockLayerArea, layerHeightNoise, layerSkewXNoise, layerSkewZNoise, forestWeirdnessNoise, forestDensityNoise);
    }

    @Override
    public void generate(ChunkData data) {
        ChunkPos pos = data.getPos();
        int blockX = pos.m_45604_();
        int blockZ = pos.m_45605_();
        int gridX = Units.blockToGrid(blockX);
        int gridZ = Units.blockToGrid(blockZ);
        Region.Point point00 = this.regionGenerator.getOrCreateRegionPoint(gridX, gridZ);
        Region.Point point01 = this.regionGenerator.getOrCreateRegionPoint(gridX, gridZ + 1);
        Region.Point point10 = this.regionGenerator.getOrCreateRegionPoint(gridX + 1, gridZ);
        Region.Point point11 = this.regionGenerator.getOrCreateRegionPoint(gridX + 1, gridZ + 1);
        LerpFloatLayer rainfallGridLayer = new LerpFloatLayer(point00.rainfall, point01.rainfall, point10.rainfall, point11.rainfall);
        LerpFloatLayer temperatureGridLayer = new LerpFloatLayer(point00.temperature, point01.temperature, point10.temperature, point11.temperature);
        double exactGridX = Units.blockToGridExact(blockX);
        double exactGridZ = Units.blockToGridExact(blockZ);
        double deltaX = exactGridX - (double)gridX;
        double deltaZ = exactGridZ - (double)gridZ;
        double dG = Units.blockToGridExact(16.0);
        LerpFloatLayer rainfallLayer = rainfallGridLayer.scaled(deltaX, deltaZ, dG);
        LerpFloatLayer temperatureLayer = temperatureGridLayer.scaled(deltaX, deltaZ, dG);
        float rainfall00 = rainfallLayer.value00();
        float rainfall01 = rainfallLayer.value01();
        float rainfall10 = rainfallLayer.value10();
        float rainfall11 = rainfallLayer.value11();
        for (RiverEdge edge : this.regionGenerator.getOrCreatePartitionPoint(gridX, gridZ).rivers()) {
            MidpointFractal fractal = edge.fractal();
            if (edge.width < 12 || !fractal.maybeIntersect(exactGridX, exactGridZ, RIVER_INFLUENCE)) continue;
            float widthInfluence = Mth.m_184637_((float)edge.width, (float)12.0f, (float)24.0f, (float)0.0f, (float)1.0f);
            rainfall00 = this.adjustRiverRainfall(rainfall00, rainfallLayer.value00(), widthInfluence, fractal, exactGridX, exactGridZ);
            rainfall01 = this.adjustRiverRainfall(rainfall01, rainfallLayer.value01(), widthInfluence, fractal, exactGridX, exactGridZ + dG);
            rainfall10 = this.adjustRiverRainfall(rainfall10, rainfallLayer.value10(), widthInfluence, fractal, exactGridX + dG, exactGridZ);
            rainfall11 = this.adjustRiverRainfall(rainfall11, rainfallLayer.value11(), widthInfluence, fractal, exactGridX + dG, exactGridZ + dG);
        }
        rainfallLayer = new LerpFloatLayer(rainfall00, rainfall01, rainfall10, rainfall11).apply(value -> Mth.m_14036_((float)value, (float)0.0f, (float)500.0f));
        ForestType forestType = this.forestTypeLayer.get(blockX >> 4, blockZ >> 4);
        float forestWeirdness = (float)this.forestWeirdnessNoise.noise(blockX + 8, blockZ + 8);
        float forestDensity = (float)this.forestDensityNoise.noise(blockX + 8, blockZ + 8);
        data.generatePartial(rainfallLayer, temperatureLayer, forestType, forestWeirdness, forestDensity);
    }

    private float adjustRiverRainfall(float currentRainfall, float originalRainfall, float widthInfluence, MidpointFractal fractal, double gridX, double gridZ) {
        float distance = (float)fractal.intersectDistance(gridX, gridZ);
        float distanceInfluence = Mth.m_184631_((float)distance, (float)0.0f, (float)RIVER_INFLUENCE_SQ, (float)1.0f, (float)0.0f);
        float targetRainfall = Math.min(originalRainfall + 275.0f, 500.0f);
        return Math.max(currentRainfall, Mth.m_14179_((float)(distanceInfluence * widthInfluence), (float)originalRainfall, (float)targetRainfall));
    }

    @Override
    public RockSettings generateRock(int x, int y, int z, int surfaceY, @Nullable ChunkRockDataCache cache) {
        return this.generateRock(x, y, z, surfaceY, cache, null);
    }

    @Override
    public void displayDebugInfo(List<String> tooltip, BlockPos pos, int surfaceY) {
        this.generateRock(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), surfaceY, null, tooltip);
    }

    private RockSettings generateRock(int x, int y, int z, int surfaceY, @Nullable ChunkRockDataCache cache, @Nullable List<String> tooltip) {
        float skewNoiseZ;
        float skewNoiseX;
        int offsetX;
        int offsetZ;
        float layerHeight;
        float adjustedSurfaceY = surfaceY;
        if (adjustedSurfaceY > 125.0f) {
            adjustedSurfaceY = 125.0f + 0.3f * (float)(surfaceY - 125);
        }
        int layer = 0;
        float deltaY = adjustedSurfaceY - (float)y;
        do {
            if (cache != null) {
                this.populateLayerInCache(cache, layer);
                layerHeight = cache.getLayerHeight(layer, x, z);
            } else {
                int layerX = x + RegionChunkDataGenerator.getOffsetX(layer);
                int layerZ = z + RegionChunkDataGenerator.getOffsetZ(layer);
                layerHeight = (float)this.layerHeightNoise.noise(layerX, layerZ);
            }
            if (deltaY <= layerHeight) break;
            ++layer;
        } while ((deltaY -= layerHeight) > 0.0f);
        if (cache != null) {
            offsetZ = 0;
            offsetX = 0;
            skewNoiseX = cache.getLayerSkewX(layer, x, z);
            skewNoiseZ = cache.getLayerSkewZ(layer, x, z);
        } else {
            offsetX = x + RegionChunkDataGenerator.getOffsetX(layer);
            offsetZ = z + RegionChunkDataGenerator.getOffsetZ(layer);
            skewNoiseX = (float)this.layerSkewXNoise.noise(offsetX, offsetZ);
            skewNoiseZ = (float)this.layerSkewZNoise.noise(offsetX, offsetZ);
        }
        int skewX = x + (int)(skewNoiseX * (deltaY + 12.0f));
        int skewZ = z + (int)(skewNoiseZ * (deltaY + 12.0f));
        int point = this.rockLayerArea.get().get(skewX, skewZ);
        RockSettings rock = this.rockLayerSettings.sampleAtLayer(point, layer);
        if (tooltip != null) {
            tooltip.add("Pos: %d, %d, %d S: %d dY: %.1f Layer: %d LayerH: %.1f".formatted(x, y, z, surfaceY, Float.valueOf(deltaY), layer, Float.valueOf(layerHeight)));
            tooltip.add("Offset: %d, %d Skew: %.1f, %.1f / %d, %d Seed: %d Type: %d".formatted(offsetX, offsetZ, Float.valueOf(skewNoiseX), Float.valueOf(skewNoiseZ), skewX, skewZ, point >> 2, point & 3));
            tooltip.add("Rock: %s".formatted(BuiltInRegistries.f_256975_.m_7981_((Object)rock.raw())));
        }
        return rock;
    }

    private void populateLayerInCache(ChunkRockDataCache cache, int layer) {
        if (cache.layers() <= layer) {
            int chunkX = cache.pos().m_45604_();
            int chunkZ = cache.pos().m_45605_();
            for (int populateLayer = cache.layers(); populateLayer <= layer; ++populateLayer) {
                float[] populatedLayerHeight = new float[256];
                float[] populatedLayerSkew = new float[512];
                int layerX = chunkX + RegionChunkDataGenerator.getOffsetX(layer);
                int layerZ = chunkZ + RegionChunkDataGenerator.getOffsetZ(layer);
                for (int dx = 0; dx < 16; ++dx) {
                    for (int dz = 0; dz < 16; ++dz) {
                        int offsetX = layerX + dx;
                        int offsetZ = layerZ + dz;
                        int i = Units.index(dx, dz);
                        populatedLayerHeight[i] = (float)this.layerHeightNoise.noise(offsetX, offsetZ);
                        populatedLayerSkew[i << 1] = (float)this.layerSkewXNoise.noise(offsetX, offsetZ);
                        populatedLayerSkew[i << 1 | 1] = (float)this.layerSkewZNoise.noise(offsetX, offsetZ);
                    }
                }
                cache.addLayer(populatedLayerHeight, populatedLayerSkew);
            }
        }
    }

    static {
        XoroshiroRandomSource random = new XoroshiroRandomSource(1923874192341L);
        for (int i = 0; i < LAYER_OFFSETS.length; ++i) {
            RegionChunkDataGenerator.LAYER_OFFSETS[i] = random.m_216339_(0, 100000);
        }
    }
}

