/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.dries007.tfc.network.ChunkWatchPacket;
import net.dries007.tfc.world.chunkdata.ChunkDataCapability;
import net.dries007.tfc.world.chunkdata.ChunkDataGenerator;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.chunkdata.LerpFloatLayer;
import net.dries007.tfc.world.chunkdata.RockData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class ChunkData {
    public static final ChunkData EMPTY = new Immutable();
    private static final float UNKNOWN_RAINFALL = 250.0f;
    private static final float UNKNOWN_TEMPERATURE = 10.0f;
    private static final Map<ChunkPos, ChunkData> CLIENT_CHUNK_QUEUE = new Object2ObjectOpenHashMap(128);
    @Nullable
    private final ChunkDataGenerator generator;
    private final ChunkPos pos;
    private Status status;
    private final RockData rockData;
    @Nullable
    private LerpFloatLayer rainfallLayer;
    @Nullable
    private LerpFloatLayer temperatureLayer;
    private int @Nullable [] aquiferSurfaceHeight;
    private ForestType forestType;
    private float forestWeirdness;
    private float forestDensity;

    public static ChunkData get(LevelReader level, BlockPos pos) {
        return ChunkData.get(level, new ChunkPos(pos));
    }

    public static ChunkData get(LevelReader level, ChunkPos pos) {
        ChunkData chunkData;
        ChunkAccess chunkAccess;
        if (level.m_7232_(pos.f_45578_, pos.f_45579_) && (chunkAccess = level.m_6325_(pos.f_45578_, pos.f_45579_)) instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunkAccess;
            chunkData = ChunkData.get(levelChunk);
        } else {
            chunkData = EMPTY;
        }
        return chunkData;
    }

    public static ChunkData get(LevelChunk chunk) {
        return chunk.m_6430_() ? EMPTY : chunk.getCapability(ChunkDataCapability.CAPABILITY).map(ChunkDataCapability::getData).orElse(EMPTY);
    }

    public static void update(LevelChunk chunk, ChunkData data) {
        chunk.getCapability(ChunkDataCapability.CAPABILITY).ifPresent(cap -> cap.setData(data));
    }

    public static ChunkData queueClientChunkDataForLoad(ChunkPos pos) {
        ChunkData data = new ChunkData(pos);
        CLIENT_CHUNK_QUEUE.put(pos, data);
        return data;
    }

    public static ChunkData dequeueClientChunkData(ChunkPos pos) {
        @Nullable ChunkData data = CLIENT_CHUNK_QUEUE.remove(pos);
        return data == null ? new ChunkData(pos) : data;
    }

    public ChunkData(ChunkPos pos) {
        this(null, pos);
    }

    public ChunkData(@Nullable ChunkDataGenerator generator, ChunkPos pos) {
        this.generator = generator;
        this.pos = pos;
        this.status = Status.EMPTY;
        this.rockData = new RockData(generator);
        this.forestType = ForestType.NONE;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public RockData getRockData() {
        return this.rockData;
    }

    public int[] getAquiferSurfaceHeight() {
        assert (this.aquiferSurfaceHeight != null);
        return this.aquiferSurfaceHeight;
    }

    public float getRainfall(BlockPos pos) {
        return this.getRainfall(pos.m_123341_(), pos.m_123343_());
    }

    public float getRainfall(int x, int z) {
        return this.rainfallLayer == null ? 250.0f : this.rainfallLayer.getValue((float)(x & 0xF) / 16.0f, (float)(z & 0xF) / 16.0f);
    }

    public float getAverageTemp(BlockPos pos) {
        return this.getAverageTemp(pos.m_123341_(), pos.m_123343_());
    }

    public float getAverageTemp(int x, int z) {
        return this.temperatureLayer == null ? 10.0f : this.temperatureLayer.getValue((float)(x & 0xF) / 16.0f, (float)(z & 0xF) / 16.0f);
    }

    public ForestType getForestType() {
        return this.forestType;
    }

    public float getForestWeirdness() {
        return this.forestWeirdness;
    }

    public float getForestDensity() {
        return this.forestDensity;
    }

    public Status status() {
        return this.status;
    }

    public void generatePartial(LerpFloatLayer rainfallLayer, LerpFloatLayer temperatureLayer, ForestType forestType, float forestWeirdness, float forestDensity) {
        assert (this.status == Status.EMPTY);
        this.rainfallLayer = rainfallLayer;
        this.temperatureLayer = temperatureLayer;
        this.forestType = forestType;
        this.forestWeirdness = forestWeirdness;
        this.forestDensity = forestDensity;
        this.status = Status.PARTIAL;
    }

    public void generateFull(int[] surfaceHeight, int[] aquiferSurfaceHeight) {
        assert (this.status == Status.PARTIAL);
        this.rockData.setSurfaceHeight(surfaceHeight);
        this.aquiferSurfaceHeight = aquiferSurfaceHeight;
        this.status = Status.FULL;
    }

    public ChunkWatchPacket getUpdatePacket() {
        assert (this.status == Status.FULL);
        assert (this.rainfallLayer != null && this.temperatureLayer != null);
        return new ChunkWatchPacket(this.pos.f_45578_, this.pos.f_45579_, this.rainfallLayer, this.temperatureLayer, this.forestType, this.forestDensity, this.forestWeirdness);
    }

    public void onUpdatePacket(LerpFloatLayer rainfallLayer, LerpFloatLayer temperatureLayer, ForestType forestType, float forestDensity, float forestWeirdness) {
        assert (this.status == Status.EMPTY || this.status == Status.CLIENT);
        this.rainfallLayer = rainfallLayer;
        this.temperatureLayer = temperatureLayer;
        this.forestType = forestType;
        this.forestDensity = forestDensity;
        this.forestWeirdness = forestWeirdness;
        this.status = Status.CLIENT;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128344_("status", (byte)this.status.ordinal());
        if (this.status == Status.FULL) {
            assert (this.aquiferSurfaceHeight != null);
            nbt.m_128385_("surfaceHeight", this.rockData.getSurfaceHeight());
            nbt.m_128385_("aquiferSurfaceHeight", this.aquiferSurfaceHeight);
        }
        if (this.status == Status.FULL || this.status == Status.PARTIAL) {
            assert (this.rainfallLayer != null);
            assert (this.temperatureLayer != null);
            nbt.m_128365_("rainfall", (Tag)this.rainfallLayer.write());
            nbt.m_128365_("temperature", (Tag)this.temperatureLayer.write());
            nbt.m_128344_("forestType", (byte)this.forestType.ordinal());
            nbt.m_128350_("forestWeirdness", this.forestWeirdness);
            nbt.m_128350_("forestDensity", this.forestDensity);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.status = Status.valueOf(nbt.m_128445_("status"));
        if (this.status == Status.FULL) {
            assert (this.generator != null);
            this.rockData.setSurfaceHeight(nbt.m_128465_("surfaceHeight"));
            this.aquiferSurfaceHeight = nbt.m_128465_("aquiferSurfaceHeight");
        }
        if (this.status == Status.FULL || this.status == Status.PARTIAL) {
            this.rainfallLayer = new LerpFloatLayer(nbt.m_128469_("rainfall"));
            this.temperatureLayer = new LerpFloatLayer(nbt.m_128469_("temperature"));
            this.forestType = ForestType.valueOf(nbt.m_128445_("forestType"));
            this.forestWeirdness = nbt.m_128457_("forestWeirdness");
            this.forestDensity = nbt.m_128457_("forestDensity");
        }
    }

    public String toString() {
        return "ChunkData{pos=" + this.pos + ", status=" + this.status + ", hashCode=" + Integer.toHexString(this.hashCode()) + "}";
    }

    public static enum Status {
        EMPTY,
        CLIENT,
        PARTIAL,
        FULL,
        INVALID;

        private static final Status[] VALUES;

        public static Status valueOf(int i) {
            return i >= 0 && i < VALUES.length ? VALUES[i] : EMPTY;
        }

        static {
            VALUES = Status.values();
        }
    }

    private static final class Immutable
    extends ChunkData {
        private Immutable() {
            super(new ChunkPos(ChunkPos.f_45577_));
        }

        @Override
        public void generatePartial(LerpFloatLayer rainfallLayer, LerpFloatLayer temperatureLayer, ForestType forestType, float forestWeirdness, float forestDensity) {
            this.error();
        }

        @Override
        public void generateFull(int[] surfaceHeight, int[] aquiferSurfaceHeight) {
            this.error();
        }

        @Override
        public void onUpdatePacket(LerpFloatLayer rainfallLayer, LerpFloatLayer temperatureLayer, ForestType forestType, float forestDensity, float forestWeirdness) {
            this.error();
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.error();
        }

        @Override
        public Status status() {
            return Status.INVALID;
        }

        @Override
        public String toString() {
            return "ImmutableChunkData";
        }

        private void error() {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }
    }
}

