/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.biome.BiomeBlendType;
import net.dries007.tfc.world.biome.BiomeBridge;
import net.dries007.tfc.world.biome.BiomeBuilder;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.river.RiverBlendType;
import net.dries007.tfc.world.surface.builder.BadlandsSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.LowlandsSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.MountainSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.NormalSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.OceanSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.RiverSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.ShoreSurfaceBuilder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public final class TFCBiomes {
    private static final Map<ResourceKey<Biome>, BiomeExtension> EXTENSIONS = new IdentityHashMap<ResourceKey<Biome>, BiomeExtension>();
    public static final BiomeExtension OCEAN = TFCBiomes.register("ocean", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.ocean(seed, -26, -12)).surface(OceanSurfaceBuilder.INSTANCE).aquiferHeightOffset(-24.0).salty().type(BiomeBlendType.OCEAN).noRivers());
    public static final BiomeExtension OCEAN_REEF = TFCBiomes.register("ocean_reef", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.ocean(seed, -16, -8)).surface(OceanSurfaceBuilder.INSTANCE).aquiferHeightOffset(-24.0).salty().type(BiomeBlendType.OCEAN).noRivers());
    public static final BiomeExtension DEEP_OCEAN = TFCBiomes.register("deep_ocean", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.ocean(seed, -30, -16)).surface(OceanSurfaceBuilder.INSTANCE).aquiferHeightOffset(-24.0).type(BiomeBlendType.OCEAN).salty().noRivers());
    public static final BiomeExtension DEEP_OCEAN_TRENCH = TFCBiomes.register("deep_ocean_trench", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.oceanRidge(seed, -30, -16)).surface(OceanSurfaceBuilder.INSTANCE).aquiferHeightOffset(-24.0).type(BiomeBlendType.OCEAN).salty().noRivers());
    public static final BiomeExtension PLAINS = TFCBiomes.register("plains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, 4, 10)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension HILLS = TFCBiomes.register("hills", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, -5, 16)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.WIDE));
    public static final BiomeExtension LOWLANDS = TFCBiomes.register("lowlands", BiomeBuilder.builder().heightmap(BiomeNoise::lowlands).surface(LowlandsSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.WIDE).noSandyRiverShores());
    public static final BiomeExtension SALT_MARSH = TFCBiomes.register("salt_marsh", BiomeBuilder.builder().heightmap(BiomeNoise::lowlands).surface(LowlandsSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).spawnable().salty().type(RiverBlendType.WIDE).noSandyRiverShores());
    public static final BiomeExtension LOW_CANYONS = TFCBiomes.register("low_canyons", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.canyons(seed, -8, 21)).surface(NormalSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).spawnable().type(RiverBlendType.WIDE).noSandyRiverShores());
    public static final BiomeExtension ROLLING_HILLS = TFCBiomes.register("rolling_hills", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, -5, 28)).surface(NormalSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.CANYON));
    public static final BiomeExtension HIGHLANDS = TFCBiomes.register("highlands", BiomeBuilder.builder().heightmap(BiomeNoise::sharpHills).surface(NormalSurfaceBuilder.ROCKY).spawnable().type(RiverBlendType.CANYON));
    public static final BiomeExtension BADLANDS = TFCBiomes.register("badlands", BiomeBuilder.builder().heightmap(BiomeNoise::badlands).surface(BadlandsSurfaceBuilder.NORMAL).spawnable().type(RiverBlendType.CANYON));
    public static final BiomeExtension INVERTED_BADLANDS = TFCBiomes.register("inverted_badlands", BiomeBuilder.builder().heightmap(BiomeNoise::bryceCanyon).surface(BadlandsSurfaceBuilder.INVERTED).spawnable().type(RiverBlendType.CANYON));
    public static final BiomeExtension PLATEAU = TFCBiomes.register("plateau", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, 20, 30)).surface(MountainSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.TALL_CANYON).noSandyRiverShores());
    public static final BiomeExtension CANYONS = TFCBiomes.register("canyons", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.canyons(seed, -2, 40)).surface(NormalSurfaceBuilder.INSTANCE).volcanoes(6, 14, 30, 28).spawnable().type(RiverBlendType.CANYON).noSandyRiverShores());
    public static final BiomeExtension MOUNTAINS = TFCBiomes.register("mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, 10, 70)).surface(MountainSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension OLD_MOUNTAINS = TFCBiomes.register("old_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, 16, 40)).surface(MountainSurfaceBuilder.INSTANCE).spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension OCEANIC_MOUNTAINS = TFCBiomes.register("oceanic_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, -16, 60)).surface(MountainSurfaceBuilder.INSTANCE).aquiferHeightOffset(-8.0).salty().spawnable().type(RiverBlendType.CAVE));
    public static final BiomeExtension VOLCANIC_MOUNTAINS = TFCBiomes.register("volcanic_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, 10, 60)).surface(MountainSurfaceBuilder.INSTANCE).volcanoes(4, 25, 50, 40).type(RiverBlendType.CAVE));
    public static final BiomeExtension VOLCANIC_OCEANIC_MOUNTAINS = TFCBiomes.register("volcanic_oceanic_mountains", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, -24, 50)).surface(MountainSurfaceBuilder.INSTANCE).aquiferHeightOffset(-8.0).salty().volcanoes(2, -12, 50, 20).type(RiverBlendType.CAVE));
    public static final BiomeExtension SHORE = TFCBiomes.register("shore", BiomeBuilder.builder().heightmap(BiomeNoise::shore).surface(ShoreSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).type(BiomeBlendType.LAND).salty().shore().type(RiverBlendType.WIDE).noRivers().noSandyRiverShores());
    public static final BiomeExtension TIDAL_FLATS = TFCBiomes.register("tidal_flats", BiomeBuilder.builder().heightmap(BiomeNoise::tidalFlats).surface(ShoreSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).type(BiomeBlendType.OCEAN).salty().shore().type(RiverBlendType.WIDE).noRivers().noSandyRiverShores());
    public static final BiomeExtension LAKE = TFCBiomes.register("lake", BiomeBuilder.builder().heightmap(BiomeNoise::lake).surface(NormalSurfaceBuilder.INSTANCE).aquiferHeightOffset(-16.0).type(BiomeBlendType.LAKE).type(RiverBlendType.WIDE).noRivers());
    public static final BiomeExtension RIVER = TFCBiomes.register("river", BiomeBuilder.builder().surface(RiverSurfaceBuilder.INSTANCE));
    public static final BiomeExtension MOUNTAIN_LAKE = TFCBiomes.register("mountain_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, 10, 70)).surface(MountainSurfaceBuilder.INSTANCE).carving(BiomeNoise::undergroundLakes).type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension OLD_MOUNTAIN_LAKE = TFCBiomes.register("old_mountain_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, -16, 60)).surface(MountainSurfaceBuilder.INSTANCE).carving(BiomeNoise::undergroundLakes).type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension OCEANIC_MOUNTAIN_LAKE = TFCBiomes.register("oceanic_mountain_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, -16, 60)).surface(MountainSurfaceBuilder.INSTANCE).carving(BiomeNoise::undergroundLakes).salty().type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension VOLCANIC_MOUNTAIN_LAKE = TFCBiomes.register("volcanic_mountain_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, 10, 60)).surface(MountainSurfaceBuilder.INSTANCE).volcanoes(4, 25, 50, 40).carving(BiomeNoise::undergroundLakes).type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension VOLCANIC_OCEANIC_MOUNTAIN_LAKE = TFCBiomes.register("volcanic_oceanic_mountain_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.mountains(seed, -24, 50)).surface(MountainSurfaceBuilder.INSTANCE).volcanoes(2, -12, 50, 20).carving(BiomeNoise::undergroundLakes).salty().type(BiomeBlendType.LAKE).noRivers());
    public static final BiomeExtension PLATEAU_LAKE = TFCBiomes.register("plateau_lake", BiomeBuilder.builder().heightmap(seed -> BiomeNoise.hills(seed, 20, 30)).surface(MountainSurfaceBuilder.INSTANCE).carving(BiomeNoise::undergroundLakes).type(BiomeBlendType.LAKE).noRivers());

    public static BiomeExtension getExtensionOrThrow(LevelAccessor level, Biome biome) {
        return Objects.requireNonNull(TFCBiomes.getExtension((CommonLevelAccessor)level, biome), () -> "Biome: " + level.m_9598_().m_175515_(Registries.f_256952_).m_7447_((Object)biome));
    }

    public static boolean hasExtension(CommonLevelAccessor level, Biome biome) {
        return TFCBiomes.getExtension(level, biome) != null;
    }

    @Nullable
    public static BiomeExtension getExtension(CommonLevelAccessor level, Biome biome) {
        return ((BiomeBridge)biome).tfc$getExtension(() -> TFCBiomes.findExtension(level, biome));
    }

    public static Collection<ResourceKey<Biome>> getAllKeys() {
        return EXTENSIONS.keySet();
    }

    public static Collection<BiomeExtension> getExtensions() {
        return EXTENSIONS.values();
    }

    public static Collection<ResourceLocation> getExtensionKeys() {
        return EXTENSIONS.keySet().stream().map(ResourceKey::m_135782_).toList();
    }

    @Nullable
    public static BiomeExtension getById(ResourceLocation id) {
        return EXTENSIONS.get(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)id));
    }

    @Nullable
    private static BiomeExtension findExtension(CommonLevelAccessor level, Biome biome) {
        RegistryAccess registryAccess = level.m_9598_();
        Registry registry = registryAccess.m_175515_(Registries.f_256952_);
        return registry.m_7854_((Object)biome).map(EXTENSIONS::get).orElse(null);
    }

    private static BiomeExtension register(String name, BiomeBuilder builder) {
        ResourceLocation id = Helpers.identifier(name);
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)id);
        BiomeExtension variants = builder.build((ResourceKey<Biome>)key);
        EXTENSIONS.put((ResourceKey<Biome>)key, variants);
        return variants;
    }
}

