/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RegionPartition;
import net.dries007.tfc.world.region.RiverEdge;
import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.settings.Settings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;

public interface BiomeSourceExtension {
    default public Holder<Biome> getBiome(int quartX, int quartZ) {
        return this.getBiomeFromExtension(this.getBiomeExtension(quartX, quartZ));
    }

    default public BiomeExtension getBiomeExtension(int quartX, int quartZ) {
        BiomeExtension biome = this.getBiomeExtensionNoRiver(quartX, quartZ);
        if (biome.hasRivers()) {
            RegionPartition.Point partitionPoint = this.getPartition(QuartPos.m_175402_((int)quartX), QuartPos.m_175402_((int)quartZ));
            double exactGridX = Units.quartToGridExact(quartX);
            double exactGridZ = Units.quartToGridExact(quartZ);
            for (RiverEdge edge : partitionPoint.rivers()) {
                if (!edge.fractal().intersect(exactGridX, exactGridZ, 0.08f)) continue;
                return TFCBiomes.RIVER;
            }
        }
        return biome;
    }

    public BiomeExtension getBiomeExtensionNoRiver(int var1, int var2);

    public Holder<Biome> getBiomeFromExtension(BiomeExtension var1);

    public RegionPartition.Point getPartition(int var1, int var2);

    default public BlockPos findSpawnBiome(Settings settings, RandomSource random) {
        int step = Math.max(1, settings.spawnDistance() / 256);
        int centerX = QuartPos.m_175400_((int)settings.spawnCenterX());
        int centerZ = QuartPos.m_175400_((int)settings.spawnCenterZ());
        int maxRadius = QuartPos.m_175400_((int)settings.spawnDistance());
        BlockPos found = null;
        int count = 0;
        for (int radius = maxRadius; radius <= maxRadius; radius += step) {
            for (int dx = -radius; dx <= radius; dx += step) {
                for (int dz = -radius; dz <= radius; dz += step) {
                    int quartX = centerX + dz;
                    int quartZ = centerZ + dx;
                    BiomeExtension biome = this.getBiomeExtensionNoRiver(quartX, quartZ);
                    if (!biome.isSpawnable()) continue;
                    if (found == null || random.m_188503_(count + 1) == 0) {
                        found = new BlockPos(QuartPos.m_175402_((int)quartX), 0, QuartPos.m_175402_((int)quartZ));
                    }
                    ++count;
                }
            }
        }
        if (found == null) {
            TerraFirmaCraft.LOGGER.warn("Unable to find spawn biome!");
            return new BlockPos(settings.spawnCenterX(), 0, settings.spawnCenterZ());
        }
        return found;
    }

    default public void initRandomState(RegionGenerator regionGenerator, ConcurrentArea<BiomeExtension> biomeLayer) {
    }

    default public BiomeSource self() {
        return (BiomeSource)this;
    }

    default public BiomeSourceExtension copy() {
        return this;
    }
}

