/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import java.util.Random;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.biome.VolcanoNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.minecraft.util.Mth;

public final class BiomeNoise {
    public static Noise2D badlands(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.025f).scaled(85.0, 95.0).add(new OpenSimplex2D(seed + 1L).octaves(4).spread(0.04f).ridged().map(x -> (double)1.3f * -(x > 0.0 ? x * x * x : 0.5 * x)).scaled(-1.0, 0.3f, -1.0, 1.0).terraces(15).scaled(-19.5, 0.0)).map(x -> x < 63.0 ? 63.0 - (double)0.3f * (63.0 - x) : x);
    }

    public static Noise2D bryceCanyon(long seed) {
        Random generator = new Random(seed);
        Noise2D noise = new OpenSimplex2D(generator.nextLong()).octaves(4).spread(0.1f).scaled(65.0, 77.0);
        for (int layer = 0; layer < 3; ++layer) {
            float threshold = 0.25f;
            float delta = 0.015f;
            noise = noise.add(new OpenSimplex2D(generator.nextLong()).octaves(3).spread(0.02f + 0.01f * (float)layer).abs().affine(1.0, -0.05f * (float)layer).map(t -> Mth.m_144851_((double)t, (double)0.25, (double)0.265f, (double)0.0, (double)1.0)).lazyProduct(new OpenSimplex2D(generator.nextLong()).octaves(4).spread(0.1f).scaled(5.0, 11.0)));
        }
        return noise;
    }

    public static Noise2D canyons(long seed, int minHeight, int maxHeight) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(4).spread(0.03f).scaled(-100.0, 100.0);
        return new OpenSimplex2D(seed + 1L).octaves(4).spread(0.06f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, 63 + minHeight, 63 + maxHeight);
    }

    public static Noise2D hills(long seed, int minHeight, int maxHeight) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.05f).scaled(63 + minHeight, 63 + maxHeight);
    }

    public static Noise2D sharpHills(long seed) {
        OpenSimplex2D base = new OpenSimplex2D(seed).octaves(4).spread(0.08f);
        Noise2D lerp = new OpenSimplex2D(seed + 7198234123L).spread(0.013f).scaled(-0.3f, 1.6f).clamped(0.0, 1.0);
        Noise2D lerpMapped = (x, z) -> {
            double in = base.noise(x, z);
            return Mth.m_14139_((double)lerp.noise(x, z), (double)in, (double)BiomeNoise.sharpHillsMap(in));
        };
        OpenSimplex2D variance = new OpenSimplex2D(seed + 67981832123L).octaves(3).spread(0.06f).scaled(-0.2f, 0.2f);
        return lerpMapped.add(variance).scaled(-0.75, 0.7f, 60.0, 91.0);
    }

    public static double sharpHillsMap(double in) {
        double in0 = 1.0;
        double in1 = 0.67f;
        double in2 = 0.15f;
        double in3 = -0.15f;
        double in4 = -0.67f;
        double in5 = -1.0;
        double out0 = 1.0;
        double out1 = 0.7f;
        double out2 = 0.5;
        double out3 = -0.5;
        double out4 = -0.7f;
        double out5 = -1.0;
        if (in > (double)0.67f) {
            return Mth.m_144914_((double)in, (double)0.67f, (double)1.0, (double)0.7f, (double)1.0);
        }
        if (in > (double)0.15f) {
            return Mth.m_144914_((double)in, (double)0.15f, (double)0.67f, (double)0.5, (double)0.7f);
        }
        if (in > (double)-0.15f) {
            return Mth.m_144914_((double)in, (double)-0.15f, (double)0.15f, (double)-0.5, (double)0.5);
        }
        if (in > (double)-0.67f) {
            return Mth.m_144914_((double)in, (double)-0.67f, (double)-0.15f, (double)-0.7f, (double)-0.5);
        }
        return Mth.m_144914_((double)in, (double)-1.0, (double)-0.67f, (double)-1.0, (double)-0.7f);
    }

    public static Noise2D lake(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.15f).scaled(51.0, 65.0).add(new OpenSimplex2D(seed + 1L).octaves(5).spread(0.1f).map(val -> val * val * val * val).scaled(-2.0, 2.0).clamped(0.0, 2.0));
    }

    public static Noise2D lowlands(long seed) {
        return BiomeNoise.hills(seed, -3, -2).add(new OpenSimplex2D(seed + 1L).octaves(6).spread(0.55f).scaled(-2.0, 2.0).clamped(-2.0, 1.0));
    }

    public static Noise2D mountains(long seed, int baseHeight, int scaleHeight) {
        Noise2D baseNoise = new OpenSimplex2D(seed).octaves(6).spread(0.14f).add(new OpenSimplex2D(seed + 1L).octaves(4).spread(0.02f).scaled(-0.7f, 0.7f).ridged()).map(x -> {
            double x0 = 0.125 * (x + 1.0) * (x + 1.0) * (x + 1.0);
            return (double)(63 + baseHeight) + (double)scaleHeight * x0;
        });
        Noise2D cliffNoise = new OpenSimplex2D(seed + 2L).octaves(2).spread(0.01f).scaled(-25.0, 25.0).map(x -> x > 0.0 ? x : 0.0);
        OpenSimplex2D cliffHeightNoise = new OpenSimplex2D(seed + 3L).octaves(2).spread(0.01f).scaled(120.0, 160.0);
        return (x, z) -> {
            double cliffHeight;
            double height = baseNoise.noise(x, z);
            if (height > 120.0 && (cliffHeight = cliffHeightNoise.noise(x, z) - height) < 0.0) {
                double mappedCliffHeight = Mth.m_144851_((double)cliffHeight, (double)0.0, (double)-1.0, (double)0.0, (double)1.0);
                height += mappedCliffHeight * cliffNoise.noise(x, z);
            }
            return height;
        };
    }

    public static Noise2D ocean(long seed, int depthMin, int depthMax) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(2).spread(0.015f).scaled(-30.0, 30.0);
        return new OpenSimplex2D(seed + 1L).octaves(4).spread(0.11f).scaled(63 + depthMin, 63 + depthMax).warped(warp);
    }

    public static Noise2D oceanRidge(long seed, int depthMin, int depthMax) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(2).spread(0.015f).scaled(-30.0, 30.0);
        Noise2D ridgeNoise = new OpenSimplex2D(seed + 1L).octaves(4).spread(0.015f).ridged().map(x -> {
            if (x > (double)-0.3f) {
                x = (x + (double)0.3f) / (double)1.3f;
                x = x * x * x;
                return -16.0 * x;
            }
            return 0.0;
        });
        return new OpenSimplex2D(seed + 2L).octaves(4).spread(0.11f).scaled(63 + depthMin, 63 + depthMax).add(ridgeNoise).warped(warp);
    }

    public static Noise2D shore(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.17f).scaled(63.0, 68.0);
    }

    public static Noise2D tidalFlats(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.17f).scaled(63.0, 64.8f);
    }

    public static Noise2D addVolcanoes(long seed, Noise2D baseNoise, int rarity, int baseVolcanoHeight, int scaleVolcanoHeight) {
        VolcanoNoise volcanoes = new VolcanoNoise(seed);
        return (x, z) -> volcanoes.modifyHeight(x, z, baseNoise.noise(x, z), rarity, baseVolcanoHeight, scaleVolcanoHeight);
    }

    public static BiomeNoiseSampler undergroundLakes(long seed, final Noise2D heightNoise) {
        final Noise2D blobsNoise = new OpenSimplex2D(seed + 1L).spread(0.04f).abs();
        final OpenSimplex2D depthNoise = new OpenSimplex2D(seed + 2L).octaves(4).scaled(2.0, 18.0).spread(0.2f);
        final OpenSimplex2D centerNoise = new OpenSimplex2D(seed + 3L).octaves(2).spread(0.06f).scaled(59.0, 67.0);
        return new BiomeNoiseSampler(){
            private double surfaceHeight;
            private double center;
            private double height;

            @Override
            public void setColumn(int x, int z) {
                double h0 = Mth.m_14008_((double)(((double)0.7f - blobsNoise.noise(x, z)) * 3.3333332538604736), (double)0.0, (double)1.0);
                double h1 = depthNoise.noise(x, z);
                this.surfaceHeight = heightNoise.noise(x, z);
                this.center = centerNoise.noise(x, z);
                this.height = h0 * h1;
            }

            @Override
            public double height() {
                return this.surfaceHeight;
            }

            @Override
            public double noise(int y) {
                double delta = Math.abs(this.center - (double)y);
                return Mth.m_14008_((double)((double)0.4f + (double)0.05f * (this.height - delta)), (double)0.0, (double)1.0);
            }
        };
    }
}

