/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.biome.AquiferLookahead;
import net.dries007.tfc.world.biome.BiomeBlendType;
import net.dries007.tfc.world.river.RiverBlendType;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.Nullable;

public class BiomeExtension {
    private final ResourceKey<Biome> key;
    @Nullable
    private final LongFunction<BiomeNoiseSampler> noiseFactory;
    private final AquiferLookahead aquiferSurfaceHeight;
    private final SurfaceBuilderFactory surfaceBuilderFactory;
    private final BiomeBlendType biomeBlendType;
    private final RiverBlendType riverBlendType;
    private final boolean salty;
    private final boolean volcanic;
    private final int volcanoRarity;
    private final int volcanoBasaltHeight;
    private final boolean spawnable;
    private final boolean rivers;
    private final boolean shore;
    private final boolean sandyRiverShores;
    @Nullable
    private List<HolderSet<PlacedFeature>> flattenedFeatures;
    @Nullable
    private Set<PlacedFeature> flattenedFeatureSet;
    @Nullable
    private Biome prevBiome;

    BiomeExtension(ResourceKey<Biome> key, @Nullable LongFunction<BiomeNoiseSampler> noiseFactory, SurfaceBuilderFactory surfaceBuilderFactory, AquiferLookahead aquiferSurfaceHeight, BiomeBlendType biomeBlendType, RiverBlendType riverBlendType, boolean salty, boolean volcanic, int volcanoRarity, int volcanoBasaltHeight, boolean spawnable, boolean rivers, boolean shore, boolean sandyRiverShores) {
        this.key = key;
        this.noiseFactory = noiseFactory;
        this.surfaceBuilderFactory = surfaceBuilderFactory;
        this.aquiferSurfaceHeight = aquiferSurfaceHeight;
        this.biomeBlendType = biomeBlendType;
        this.riverBlendType = riverBlendType;
        this.salty = salty;
        this.volcanic = volcanic;
        this.volcanoRarity = volcanoRarity;
        this.volcanoBasaltHeight = volcanoBasaltHeight;
        this.spawnable = spawnable;
        this.rivers = rivers;
        this.shore = shore;
        this.sandyRiverShores = sandyRiverShores;
    }

    public ResourceKey<Biome> key() {
        return this.key;
    }

    public BiomeBlendType biomeBlendType() {
        return this.biomeBlendType;
    }

    public RiverBlendType riverBlendType() {
        return this.riverBlendType;
    }

    public boolean hasSandyRiverShores() {
        return this.sandyRiverShores;
    }

    public boolean isSalty() {
        return this.salty;
    }

    public boolean isVolcanic() {
        return this.volcanic;
    }

    public boolean isSpawnable() {
        return this.spawnable;
    }

    public boolean hasRivers() {
        return this.rivers;
    }

    public boolean isShore() {
        return this.shore;
    }

    public int getVolcanoRarity() {
        return this.volcanoRarity;
    }

    public int getVolcanoBasaltHeight() {
        return this.volcanoBasaltHeight;
    }

    public double getAquiferSurfaceHeight(BiomeNoiseSampler sampler, int x, int z) {
        return this.aquiferSurfaceHeight.getHeight(sampler, x, z);
    }

    @Nullable
    public BiomeNoiseSampler createNoiseSampler(long seed) {
        return this.noiseFactory != null ? this.noiseFactory.apply(seed) : null;
    }

    public SurfaceBuilder createSurfaceBuilder(long seed) {
        return this.surfaceBuilderFactory.apply(seed);
    }

    public List<HolderSet<PlacedFeature>> getFlattenedFeatures(Biome biome) {
        if (biome != this.prevBiome) {
            this.prevBiome = biome;
            this.flattenedFeatures = null;
        }
        if (this.flattenedFeatures == null) {
            this.flattenedFeatures = biome.m_47536_().m_47818_();
            this.flattenedFeatureSet = this.flattenedFeatures.stream().flatMap(HolderSet::m_203614_).map(Holder::m_203334_).collect(Collectors.toSet());
        }
        return this.flattenedFeatures;
    }

    public Set<PlacedFeature> getFlattenedFeatureSet(Biome biome) {
        this.getFlattenedFeatures(biome);
        return Objects.requireNonNull(this.flattenedFeatureSet);
    }
}

