/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.placement.ClimatePlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public final class TFCStructureHooks {
    public static final DeferredRegister<StructurePlacementType<?>> STRUCTURE_PLACEMENTS = DeferredRegister.create((ResourceKey)Registries.f_256888_, (String)"tfc");
    public static final RegistryObject<StructurePlacementType<ClimateStructurePlacement>> CLIMATE = TFCStructureHooks.register("climate", ClimateStructurePlacement.PLACEMENT_CODEC);

    private static <T extends StructurePlacement> RegistryObject<StructurePlacementType<T>> register(String name, Codec<T> codec) {
        return STRUCTURE_PLACEMENTS.register(name, () -> () -> codec);
    }

    public static class ClimateStructurePlacement
    extends RandomSpreadStructurePlacement {
        private static final MapCodec<ClimateSettings> CLIMATE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(ClimateSettings::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(ClimateSettings::separation), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(ClimateSettings::randomSpreadType), (App)ClimatePlacement.PLACEMENT_CODEC.fieldOf("climate").forGetter(ClimateSettings::climate)).apply((Applicative)instance, ClimateSettings::new));
        public static final Codec<ClimateStructurePlacement> PLACEMENT_CODEC = ExtraCodecs.m_285994_((MapCodec)RecordCodecBuilder.mapCodec(instance -> ClimateStructurePlacement.m_227041_((RecordCodecBuilder.Instance)instance).and((App)CLIMATE_CODEC.forGetter(c -> c.settings)).apply((Applicative)instance, ClimateStructurePlacement::new)), ClimateStructurePlacement::validate).codec();
        private final ClimateSettings settings;

        private static DataResult<ClimateStructurePlacement> validate(ClimateStructurePlacement placement) {
            return placement.m_205003_() <= placement.m_205004_() ? DataResult.error(() -> "Spacing has to be larger than separation") : DataResult.success((Object)((Object)placement));
        }

        public ClimateStructurePlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod freqReduction, float frequency, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, ClimateSettings settings) {
            super(locateOffset, freqReduction, frequency, salt, exclusionZone, settings.spacing, settings.separation, settings.randomSpreadType);
            this.settings = settings;
        }

        protected boolean m_214090_(ChunkGeneratorStructureState state, int x, int z) {
            if (!super.m_214090_(state, x, z)) {
                return false;
            }
            ChunkGeneratorExtension ex = ChunkGeneratorExtension.getFromStructureState(state);
            if (ex == null) {
                return false;
            }
            ChunkPos chunkPos = new ChunkPos(x, z);
            int blockX = chunkPos.m_45604_();
            int blockZ = chunkPos.m_45605_();
            BlockPos pos = new BlockPos(blockX, 0, blockZ);
            ChunkData data = ex.chunkDataProvider().createAndGeneratePartial(chunkPos);
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.m_190058_(state.m_254887_(), x, z, this.m_227075_());
            return this.settings.climate.isValid(data, pos, (RandomSource)random);
        }

        public StructurePlacementType<?> m_203443_() {
            return (StructurePlacementType)CLIMATE.get();
        }

        record ClimateSettings(int spacing, int separation, RandomSpreadType randomSpreadType, ClimatePlacement climate) {
        }
    }
}

