/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.dries007.tfc.util.StrictOptionalCodec;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.util.collections.Weighted;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.material.Fluid;

public final class Codecs
extends ExtraCodecs {
    public static final Codec<Float> UNIT_FLOAT = Codec.floatRange((float)0.0f, (float)1.0f);
    public static final Codec<Block> BLOCK = Codecs.nonDefaultedRegistryCodec(BuiltInRegistries.f_256975_);
    public static final Codec<Fluid> FLUID = Codecs.nonDefaultedRegistryCodec(BuiltInRegistries.f_257020_);
    public static final Codec<BlockState> BLOCK_STATE = Codec.either((Codec)BLOCK.xmap(Block::m_49966_, BlockBehaviour.BlockStateBase::m_60734_), (Codec)BlockState.f_61039_).xmap(e -> (BlockState)e.map(e1 -> e1, e1 -> e1), e -> e == e.m_60734_().m_49966_() ? Either.left((Object)e) : Either.right((Object)e));
    public static final Codec<Map<Block, IWeighted<BlockState>>> BLOCK_TO_WEIGHTED_BLOCKSTATE = Codecs.mapKeyListCodec(Codec.mapPair((MapCodec)BLOCK.listOf().fieldOf("replace"), (MapCodec)Codecs.weightedCodec(BLOCK_STATE, "block").fieldOf("with")).codec());
    public static final Codec<BlockStateConfiguration> BLOCK_STATE_CONFIG = BLOCK_STATE.fieldOf("state").xmap(BlockStateConfiguration::new, c -> c.f_67547_).codec();

    public static <R> Codec<R> nonDefaultedRegistryCodec(Registry<R> registry) {
        return ResourceLocation.f_135803_.flatXmap(id -> registry.m_6612_(id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry entry: " + id + " for registry: " + registry.m_123023_())), value -> DataResult.success((Object)registry.m_7981_(value)));
    }

    public static <F, S> Codec<Pair<F, S>> recordPairCodec(Codec<F> first, String firstKey, Codec<S> second, String secondKey) {
        return Codec.mapPair((MapCodec)first.fieldOf(firstKey), (MapCodec)second.fieldOf(secondKey)).codec();
    }

    public static <E> Codec<IWeighted<E>> weightedCodec(Codec<E> elementCodec, String elementKey) {
        return Codec.mapPair((MapCodec)elementCodec.fieldOf(elementKey), (MapCodec)Codec.DOUBLE.optionalFieldOf("weight", (Object)1.0)).codec().listOf().xmap(list -> {
            if (list.isEmpty()) {
                return IWeighted.empty();
            }
            if (list.size() == 1) {
                return IWeighted.singleton(((Pair)list.get(0)).getFirst());
            }
            return new Weighted(list);
        }, IWeighted::weightedValues);
    }

    public static <K, V> Codec<Map<K, V>> mapKeyListCodec(Codec<Pair<List<K>, V>> codec) {
        return codec.listOf().xmap(list -> {
            HashMap map = new HashMap();
            for (Pair pair : list) {
                for (Object key : (List)pair.getFirst()) {
                    map.put(key, pair.getSecond());
                }
            }
            return map;
        }, map -> {
            HashMap<Object, List> inverseMap = new HashMap<Object, List>();
            for (Map.Entry entry : map.entrySet()) {
                inverseMap.computeIfAbsent(entry.getValue(), v -> new ArrayList()).add(entry.getKey());
            }
            return inverseMap.entrySet().stream().map(e -> Pair.of((Object)((List)e.getValue()), e.getKey())).toList();
        });
    }

    public static <K, V> Codec<Map<K, V>> mapListCodec(Codec<Pair<K, V>> codec) {
        return codec.listOf().xmap(list -> list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).toList());
    }

    public static <T> Codec<T> presetIdOrDirectCodec(Codec<T> directCodec, Map<ResourceLocation, T> presets) {
        return Codec.either((Codec)ResourceLocation.f_135803_, directCodec).comapFlatMap(e -> (DataResult)e.map(id -> {
            Object element = presets.get(id);
            return element == null ? DataResult.error(() -> "No element with id: " + id) : DataResult.success(element);
        }, DataResult::success), Either::right);
    }

    public static <T> MapCodec<Optional<T>> optionalFieldOf(Codec<T> codec, String field) {
        return new StrictOptionalCodec<T>(field, codec);
    }

    public static <T> MapCodec<T> optionalFieldOf(Codec<T> codec, String field, T defaultValue) {
        return Codecs.optionalFieldOf(codec, field).xmap(o -> o.orElse(defaultValue), a -> Objects.equals(a, defaultValue) ? Optional.empty() : Optional.of(a));
    }
}

