/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.dries007.tfc.world.Sampler;
import net.dries007.tfc.world.biome.BiomeBlendType;
import net.dries007.tfc.world.noise.Kernel;
import net.minecraft.world.level.ChunkPos;

public final class ChunkBiomeSampler {
    public static final Kernel KERNEL_9x9 = Kernel.create((x, z) -> 0.0211640211641 * (1.0 - 0.03125 * (double)(z * z + x * x)), 4);

    public static <T> Object2DoubleMap<T>[] sampleBiomes(ChunkPos pos, Sampler<T> biomeSampler, Function<T, BiomeBlendType> groupFunction) {
        Object2DoubleMap<T>[] chunkBiomeWeightArray = ChunkBiomeSampler.newWeightArray(16);
        int chunkX = pos.m_45604_();
        int chunkZ = pos.m_45605_();
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                Object2DoubleOpenHashMap chunkBiomeWeight;
                chunkBiomeWeightArray[x | z << 2] = chunkBiomeWeight = new Object2DoubleOpenHashMap();
                ChunkBiomeSampler.sampleBiomesAtPositionWithKernel(chunkBiomeWeight, biomeSampler, KERNEL_9x9, 4, chunkX, chunkZ, x - 1, z - 1);
            }
        }
        Object2DoubleMap<T>[] quartBiomeWeightArray = ChunkBiomeSampler.newWeightArray(49);
        Object2DoubleOpenHashMap chunkBiomeWeight = new Object2DoubleOpenHashMap();
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                Object2DoubleOpenHashMap quartBiomeWeight = new Object2DoubleOpenHashMap();
                chunkBiomeWeight.clear();
                ChunkBiomeSampler.sampleBiomesAtPositionWithKernel(quartBiomeWeight, biomeSampler, KERNEL_9x9, 2, chunkX, chunkZ, x - 1, z - 1);
                int x1 = chunkX + (x - 1 << 2);
                int z1 = chunkZ + (z - 1 << 2);
                int coordX = x1 >> 4;
                int coordZ = z1 >> 4;
                double lerpX = (double)(x1 - (coordX << 4)) * 0.0625;
                double lerpZ = (double)(z1 - (coordZ << 4)) * 0.0625;
                int index16X = (x1 - chunkX >> 4) + 1;
                int index16Z = (z1 - chunkZ >> 4) + 1;
                ChunkBiomeSampler.sampleBiomesCornerContribution(chunkBiomeWeight, chunkBiomeWeightArray[index16X | index16Z << 2], (1.0 - lerpX) * (1.0 - lerpZ));
                ChunkBiomeSampler.sampleBiomesCornerContribution(chunkBiomeWeight, chunkBiomeWeightArray[index16X + 1 | index16Z << 2], lerpX * (1.0 - lerpZ));
                ChunkBiomeSampler.sampleBiomesCornerContribution(chunkBiomeWeight, chunkBiomeWeightArray[index16X | index16Z + 1 << 2], (1.0 - lerpX) * lerpZ);
                ChunkBiomeSampler.sampleBiomesCornerContribution(chunkBiomeWeight, chunkBiomeWeightArray[index16X + 1 | index16Z + 1 << 2], lerpX * lerpZ);
                ChunkBiomeSampler.composeSampleWeights(quartBiomeWeight, chunkBiomeWeight, biome -> {
                    BiomeBlendType group = (BiomeBlendType)((Object)((Object)groupFunction.apply(biome)));
                    return group.ordinal();
                }, BiomeBlendType.SIZE);
                quartBiomeWeightArray[x + 7 * z] = quartBiomeWeight;
            }
        }
        return quartBiomeWeightArray;
    }

    public static <T> void sampleBiomesColumn(Object2DoubleMap<T> accumulator, Object2DoubleMap<T>[] corners, int localX, int localZ) {
        int index4X = (localX >> 2) + 1;
        int index4Z = (localZ >> 2) + 1;
        double lerpX = (double)(localX - (localX >> 2 << 2)) * 0.25;
        double lerpZ = (double)(localZ - (localZ >> 2 << 2)) * 0.25;
        accumulator.clear();
        ChunkBiomeSampler.sampleBiomesCornerContribution(accumulator, corners[index4X + index4Z * 7], (1.0 - lerpX) * (1.0 - lerpZ));
        ChunkBiomeSampler.sampleBiomesCornerContribution(accumulator, corners[index4X + 1 + index4Z * 7], lerpX * (1.0 - lerpZ));
        ChunkBiomeSampler.sampleBiomesCornerContribution(accumulator, corners[index4X + (index4Z + 1) * 7], (1.0 - lerpX) * lerpZ);
        ChunkBiomeSampler.sampleBiomesCornerContribution(accumulator, corners[index4X + 1 + (index4Z + 1) * 7], lerpX * lerpZ);
    }

    private static <T> void sampleBiomesCornerContribution(Object2DoubleMap<T> accumulator, Object2DoubleMap<T> corner, double t) {
        if (t > 0.0) {
            for (Object2DoubleMap.Entry entry : corner.object2DoubleEntrySet()) {
                accumulator.mergeDouble(entry.getKey(), entry.getDoubleValue() * t, Double::sum);
            }
        }
    }

    private static <T> void sampleBiomesAtPositionWithKernel(Object2DoubleMap<T> weights, Sampler<T> biomeSampler, Kernel kernel, int kernelBits, int chunkX, int chunkZ, int xOffsetInKernelBits, int zOffsetInKernelBits) {
        int kernelRadius = kernel.radius();
        int kernelWidth = kernel.width();
        for (int dx = -kernelRadius; dx <= kernelRadius; ++dx) {
            for (int dz = -kernelRadius; dz <= kernelRadius; ++dz) {
                double weight = kernel.values()[dx + kernelRadius + (dz + kernelRadius) * kernelWidth];
                int blockX = chunkX + (xOffsetInKernelBits + dx << kernelBits);
                int blockZ = chunkZ + (zOffsetInKernelBits + dz << kernelBits);
                T biome = biomeSampler.get(blockX, blockZ);
                weights.mergeDouble(biome, weight, Double::sum);
            }
        }
    }

    private static <T> void composeSampleWeights(Object2DoubleMap<T> weightMap, Object2DoubleMap<T> groupWeightMap, ToIntFunction<T> groupFunction, int groups) {
        double[] maxWeights = new double[groups];
        for (Object2DoubleMap.Entry entry : groupWeightMap.object2DoubleEntrySet()) {
            int group = groupFunction.applyAsInt(entry.getKey());
            if (group == -1) continue;
            int n = group;
            maxWeights[n] = maxWeights[n] + entry.getDoubleValue();
        }
        double[] actualWeights = new double[groups];
        ObjectIterator iterator = weightMap.object2DoubleEntrySet().iterator();
        while (iterator.hasNext()) {
            Object2DoubleMap.Entry entry = (Object2DoubleMap.Entry)iterator.next();
            int group = groupFunction.applyAsInt(entry.getKey());
            if (group == -1) continue;
            int n = group;
            actualWeights[n] = actualWeights[n] + entry.getDoubleValue();
            iterator.remove();
        }
        for (Object2DoubleMap.Entry entry : groupWeightMap.object2DoubleEntrySet()) {
            int group = groupFunction.applyAsInt(entry.getKey());
            if (group == -1 || !(actualWeights[group] > 0.0) || !(maxWeights[group] > 0.0)) continue;
            weightMap.put(entry.getKey(), entry.getDoubleValue() * actualWeights[group] / maxWeights[group]);
        }
    }

    private static <T> Object2DoubleMap<T>[] newWeightArray(int size) {
        return new Object2DoubleMap[size];
    }
}

