/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.rotation;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.dries007.tfc.util.rotation.NetworkAddAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.Rotation;
import net.dries007.tfc.util.rotation.RotationAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Nullable;

final class RotationNetwork {
    private final long id;
    private final Node source;
    private final Long2ObjectMap<Node> nodes;

    RotationNetwork(long id, Node source) {
        this.id = id;
        this.source = source;
        this.nodes = new Long2ObjectOpenHashMap();
    }

    @CheckReturnValue
    NetworkAddAction updateOnAdd(Node toAdd) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        record PendingConnection(Node node, Direction direction, Rotation rotation) {
        }
        @Nullable PendingConnection pendingConnection = null;
        for (Direction direction : toAdd.connections()) {
            cursor.m_122159_((Vec3i)toAdd.pos(), direction);
            @Nullable Node adjacentNode = this.getNode((BlockPos)cursor);
            Direction inverseDirection = direction.m_122424_();
            if (adjacentNode == null || !adjacentNode.connections().contains(inverseDirection) || adjacentNode.source() == inverseDirection) continue;
            assert (adjacentNode.network() == this.id);
            if (toAdd.network() != -1L && toAdd.network() != this.id) {
                return NetworkAddAction.FAIL_CONNECTED_TO_OTHER_NETWORK;
            }
            if (pendingConnection != null) {
                Rotation adjacentRotation = adjacentNode.rotation(inverseDirection);
                assert (adjacentRotation != null);
                if (toAdd.rotation(pendingConnection.rotation, pendingConnection.direction, direction).direction() == adjacentRotation.direction()) continue;
                return NetworkAddAction.FAIL_INVALID_CONNECTION;
            }
            Rotation pendingRotation = adjacentNode.rotation(inverseDirection);
            assert (pendingRotation != null);
            pendingConnection = new PendingConnection(adjacentNode, direction, pendingRotation);
        }
        if (pendingConnection != null) {
            if (toAdd.network() == this.id) {
                return NetworkAddAction.SUCCESS;
            }
            if (!toAdd.update(this.id, pendingConnection.direction, pendingConnection.rotation)) {
                return NetworkAddAction.FAIL_INVALID_CONNECTION;
            }
            this.nodes.put(toAdd.posKey(), (Object)toAdd);
            return NetworkAddAction.SUCCESS;
        }
        return NetworkAddAction.FAIL_NO_CONNECTION;
    }

    void updateAfterAdd(Node added, RotationAccess level) {
        assert (added.network() == this.id);
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        queue.add(added);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            for (Direction direction : current.connections()) {
                cursor.m_122159_((Vec3i)current.pos(), direction);
                @Nullable Node next = level.getNode((BlockPos)cursor);
                Direction inverseDirection = direction.m_122424_();
                if (next == null || next.network() != -1L || !next.connections().contains(inverseDirection) || current.source() == direction || this.nodes.containsKey(next.posKey())) continue;
                Rotation exitRotation = current.rotation(direction);
                assert (exitRotation != null);
                if (!next.update(this.id, inverseDirection, exitRotation)) continue;
                queue.add(next);
                this.nodes.put(next.posKey(), (Object)next);
            }
        }
    }

    void removeNode(Node toRemove) {
        assert (toRemove.network() == this.id);
        this.nodes.remove(toRemove.posKey());
    }

    void updateNetwork() {
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        ReferenceOpenHashSet visited = new ReferenceOpenHashSet();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        queue.add(this.source);
        visited.addAll(this.nodes.values());
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            for (Direction direction : current.connections()) {
                cursor.m_122159_((Vec3i)current.pos(), direction);
                @Nullable Node next = this.getNode((BlockPos)cursor);
                Direction inverseDirection = direction.m_122424_();
                if (next == null || !next.connections().contains(inverseDirection) || !visited.contains(next)) continue;
                Rotation exitRotation = current.rotation(direction);
                assert (exitRotation != null);
                if (!next.update(this.id, inverseDirection, exitRotation)) continue;
                queue.add(next);
                visited.remove(next);
            }
        }
        for (Node node : visited) {
            node.remove();
            this.nodes.remove(node.posKey());
        }
    }

    void removeNetwork() {
        for (Node node : this.nodes.values()) {
            node.remove();
        }
        this.nodes.clear();
    }

    boolean isSource(Node node) {
        return this.source == node;
    }

    long networkId() {
        return this.id;
    }

    public String toString() {
        return "[network=%d]\n%s\n%s".formatted(this.id, this.source, this.nodes.values().stream().sorted(Comparator.comparing(Node::pos)).map(e -> e + "\n").collect(Collectors.joining()));
    }

    @Nullable
    private Node getNode(BlockPos pos) {
        return pos.equals((Object)this.source.pos()) ? this.source : (Node)this.nodes.get(pos.m_121878_());
    }
}

