/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import java.time.LocalDate;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.accessor.GameRulesAccessor;
import net.dries007.tfc.mixin.accessor.GameRulesTypeAccessor;
import net.dries007.tfc.network.CalendarUpdatePacket;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.util.ReentrantListener;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.calendar.Calendar;
import net.dries007.tfc.util.calendar.CalendarTransaction;
import net.dries007.tfc.util.calendar.CalendarWorldData;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class ServerCalendar
extends Calendar {
    public static final int SYNC_INTERVAL = 20;
    public static final int TIME_DESYNC_THRESHOLD = 5;
    private static final ReentrantListener DO_DAYLIGHT_CYCLE = new ReentrantListener(() -> Calendars.SERVER.setDoDaylightCycle());
    private int syncCounter;

    public static void overrideDoDaylightCycleCallback() {
        GameRulesTypeAccessor type = (GameRulesTypeAccessor)GameRulesAccessor.accessor$getGameRuleTypes().get(GameRules.f_46140_);
        type.accessor$setCallback(type.accessor$getCallback().andThen((server, t) -> DO_DAYLIGHT_CYCLE.onListenerUpdate()));
    }

    public CalendarTransaction transaction() {
        return new Transaction();
    }

    public void setTimeFromCalendarTime(long calendarTimeToSetTo) {
        long timeJump = calendarTimeToSetTo - this.calendarTicks;
        this.calendarTicks = calendarTimeToSetTo;
        this.playerTicks += timeJump;
        for (ServerLevel world : this.getServer().m_129785_()) {
            long currentDayTime = world.m_46468_();
            world.m_8615_(currentDayTime + timeJump);
        }
        this.sendUpdatePacket();
    }

    public long setTimeFromDayTime(long worldTimeToSetTo) {
        long worldTimeJump = worldTimeToSetTo % 24000L - this.getCalendarDayTime();
        if (worldTimeJump < 0L) {
            worldTimeJump += 24000L;
        }
        this.calendarTicks += worldTimeJump;
        this.playerTicks += worldTimeJump;
        return worldTimeJump;
    }

    public void setMonthLength(int newMonthLength) {
        long baseMonths = this.getTotalCalendarMonths();
        long baseDayTime = this.calendarTicks - this.getTotalCalendarDays() * 24000L;
        float monthPercent = (float)(this.getCalendarDayOfMonth() - 1) / (float)this.daysInMonth;
        int newDayOfMonth = (int)(monthPercent * (float)newMonthLength);
        this.daysInMonth = newMonthLength;
        this.calendarTicks = (baseMonths * (long)this.daysInMonth + (long)newDayOfMonth) * 24000L + baseDayTime;
        this.sendUpdatePacket();
    }

    public void setPlayersLoggedOn(boolean arePlayersLoggedOn) {
        boolean alwaysRunAsIfPlayersAreLoggedIn = (Boolean)TFCConfig.SERVER.enableTimeStopWhenServerEmpty.get() == false;
        boolean bl = this.arePlayersLoggedOn = arePlayersLoggedOn || alwaysRunAsIfPlayersAreLoggedIn;
        if (this.arePlayersLoggedOn) {
            this.setDoDaylightCycleWithNoCallback(this.doDaylightCycle);
            LOGGER.info(alwaysRunAsIfPlayersAreLoggedIn ? "Calendar = true, Daylight = {} due to enableTimeStopWhenServerEmpty = false" : "Calendar = true, Daylight = {} due to players logged in", (Object)this.doDaylightCycle);
        } else {
            this.setDoDaylightCycleWithNoCallback(false);
            LOGGER.info("Calendar = false, Daylight = false ({}) due to no players logged in", (Object)this.doDaylightCycle);
        }
        this.sendUpdatePacket();
    }

    public void setDoDaylightCycle() {
        GameRules rules = this.getServer().m_129900_();
        this.doDaylightCycle = rules.m_46207_(GameRules.f_46140_);
        if (!this.arePlayersLoggedOn) {
            this.setDoDaylightCycleWithNoCallback(false);
            LOGGER.info("Calendar = false, Daylight = false ({}) due to no players logged in (updated the value for when players log back in)", (Object)this.doDaylightCycle);
        }
        this.sendUpdatePacket();
    }

    void onServerStart(MinecraftServer server) {
        boolean alwaysRunAsIfPlayersAreLoggedIn;
        boolean bl = alwaysRunAsIfPlayersAreLoggedIn = (Boolean)TFCConfig.SERVER.enableTimeStopWhenServerEmpty.get() == false;
        if (!alwaysRunAsIfPlayersAreLoggedIn) {
            this.setDoDaylightCycleWithNoCallback(false);
        }
        this.resetTo(CalendarWorldData.get(server.m_129783_()).getCalendar());
        this.sendUpdatePacket();
        if (server instanceof GameTestServer) {
            this.setPlayersLoggedOn(true);
        }
    }

    void onServerStop() {
        this.resetToDefault();
    }

    void onServerTick() {
        if (this.arePlayersLoggedOn) {
            ++this.playerTicks;
        }
        ++this.syncCounter;
        if (this.syncCounter >= 20) {
            this.sendUpdatePacket();
            this.syncCounter = 0;
        }
    }

    void onOverworldTick(ServerLevel level) {
        long deltaWorldTime;
        if (this.doDaylightCycle && this.arePlayersLoggedOn) {
            ++this.calendarTicks;
        }
        if ((deltaWorldTime = level.m_46468_() % 24000L - this.getCalendarDayTime()) > 5L || deltaWorldTime < -5L) {
            boolean bl = this.arePlayersLoggedOn = this.getServer().m_6846_().m_11309_() > 0 || (Boolean)TFCConfig.SERVER.enableTimeStopWhenServerEmpty.get() == false;
            if (this.arePlayersLoggedOn) {
                this.doDaylightCycle = this.getServer().m_129900_().m_46207_(GameRules.f_46140_);
            } else {
                this.setDoDaylightCycleWithNoCallback(false);
            }
            if (deltaWorldTime < 0L) {
                level.m_8615_(level.m_46468_() - deltaWorldTime);
            } else {
                this.calendarTicks += deltaWorldTime;
            }
            LOGGER.warn("Calendar is out of sync - trying to fix: Calendar = {}, Daylight = {} ({}), Sync = {}", new Object[]{this.arePlayersLoggedOn, this.getServer().m_129900_().m_46207_(GameRules.f_46140_), this.doDaylightCycle, deltaWorldTime});
            this.sendUpdatePacket();
        }
        if (level.m_46467_() % 200L == 0L) {
            this.checkIfInTheFuture(level);
        }
    }

    void checkIfInTheFuture(ServerLevel level) {
        LocalDate calendarDate;
        LocalDate date = LocalDate.now();
        if (date.isBefore(calendarDate = LocalDate.of(Mth.m_14045_((int)((int)this.getTotalCalendarYears()), (int)-999999999, (int)999999999), this.getCalendarMonthOfYear().ordinal() + 1, Mth.m_14045_((int)this.getCalendarDayOfMonth(), (int)1, (int)28)))) {
            level.m_7654_().m_6846_().m_11314_().forEach(TFCAdvancements.PRESENT_DAY::trigger);
        }
    }

    void sendUpdatePacket() {
        PacketHandler.send(PacketDistributor.ALL.noArg(), new CalendarUpdatePacket(this));
    }

    private MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    private void setDoDaylightCycleWithNoCallback(boolean value) {
        MinecraftServer server = this.getServer();
        DO_DAYLIGHT_CYCLE.runWithoutTriggeringCallbacks(() -> ((GameRules.BooleanValue)server.m_129900_().m_46170_(GameRules.f_46140_)).m_46246_(value, server));
    }

    private class Transaction
    implements CalendarTransaction {
        private final long originalPlayerTicks;
        private final long originalCalendarTicks;

        private Transaction() {
            this.originalPlayerTicks = ServerCalendar.this.playerTicks;
            this.originalCalendarTicks = ServerCalendar.this.calendarTicks;
        }

        @Override
        public void add(long playerTicks, long calendarTicks) {
            ServerCalendar.this.playerTicks += playerTicks;
            ServerCalendar.this.calendarTicks += calendarTicks;
        }

        @Override
        public void close() {
            ServerCalendar.this.playerTicks = this.originalPlayerTicks;
            ServerCalendar.this.calendarTicks = this.originalCalendarTicks;
        }
    }
}

