/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TimeDeltaTooltipStyle;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Day;
import net.dries007.tfc.util.calendar.Month;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public interface ICalendar {
    public static final int TICKS_IN_HOUR = 1000;
    public static final int HOURS_IN_DAY = 24;
    public static final int TICKS_IN_DAY = 24000;
    public static final int MONTHS_IN_YEAR = 12;
    public static final float TICKS_IN_MINUTE = 16.666666f;

    public static long getCalendarTicksInMonth(int daysInMonth) {
        return 24000L * (long)daysInMonth;
    }

    public static long getCalendarTicksInYear(int daysInMonth) {
        return 24000L * (long)daysInMonth * 12L;
    }

    public static float getTotalMinutes(long time) {
        return (float)time / 16.666666f;
    }

    public static long getTotalHours(long time) {
        return time / 1000L;
    }

    public static long getTotalDays(long time) {
        return time / 24000L;
    }

    public static long getTotalMonths(long time, long daysInMonth) {
        return time / (daysInMonth * 24000L);
    }

    public static long getTotalYears(long time, long daysInMonth) {
        return 1000L + time / (12L * daysInMonth * 24000L);
    }

    public static int getMinuteOfHour(long time) {
        return (int)((float)(time % 1000L) / 16.666666f);
    }

    public static int getHourOfDay(long time) {
        return (int)(time / 1000L % 24L);
    }

    public static int getDayOfMonth(long time, long daysInMonth) {
        return 1 + (int)(time / 24000L % daysInMonth);
    }

    public static float getFractionOfMonth(long time, long daysInMonth) {
        long ticksInMonth = daysInMonth * 24000L;
        return (float)(time % ticksInMonth) / (float)ticksInMonth;
    }

    public static float getFractionOfYear(long time, long daysInMonth) {
        long ticksInYear = 12L * daysInMonth * 24000L;
        return (float)(time % ticksInYear) / (float)ticksInYear;
    }

    public static Month getMonthOfYear(long time, long daysInMonth) {
        long ticksInMonth = daysInMonth * 24000L;
        return Month.valueOf((int)(time / ticksInMonth % 12L));
    }

    public static MutableComponent getTimeAndDate(long time, long daysInMonth) {
        return ICalendar.getTimeAndDate(ICalendar.getHourOfDay(time), ICalendar.getMinuteOfHour(time), ICalendar.getMonthOfYear(time, daysInMonth), ICalendar.getDayOfMonth(time, daysInMonth), ICalendar.getTotalYears(time, daysInMonth));
    }

    public static MutableComponent getTimeAndDate(int hour, int minute, Month month, int day, long years) {
        return Component.m_237110_((String)"tfc.tooltip.calendar_hour_minute_month_day_year", (Object[])new Object[]{String.format("%d:%02d", hour, minute), Helpers.translateEnum(month), day, years});
    }

    public static MutableComponent getTimeDelta(long ticks, int daysInMonth) {
        long hours = ICalendar.getTotalHours(ticks);
        if (hours < 1L) {
            return Component.m_237110_((String)"tfc.tooltip.time_delta_hours_minutes", (Object[])new Object[]{"00", String.format("%02d", ICalendar.getMinuteOfHour(ticks))});
        }
        long days = ICalendar.getTotalDays(ticks);
        if (days < 1L) {
            return Component.m_237110_((String)"tfc.tooltip.time_delta_hours_minutes", (Object[])new Object[]{hours, String.format("%02d", ICalendar.getMinuteOfHour(ticks))});
        }
        long months = ICalendar.getTotalMonths(ticks, daysInMonth);
        TimeDeltaTooltipStyle style = (TimeDeltaTooltipStyle)((Object)TFCConfig.CLIENT.timeDeltaTooltipStyle.get());
        if (months < 1L || style == TimeDeltaTooltipStyle.DAYS) {
            return Component.m_237110_((String)"tfc.tooltip.time_delta_days", (Object[])new Object[]{days});
        }
        long years = ICalendar.getTotalYears(ticks, daysInMonth) - 1000L;
        if (years < 1L || style == TimeDeltaTooltipStyle.DAYS_MONTHS) {
            return Component.m_237110_((String)"tfc.tooltip.time_delta_months_days", (Object[])new Object[]{months, days % (long)daysInMonth});
        }
        return Component.m_237110_((String)"tfc.tooltip.time_delta_years_months_days", (Object[])new Object[]{years, months % 12L, days % (long)daysInMonth});
    }

    public long getTicks();

    public long getCalendarTicks();

    public int getCalendarDaysInMonth();

    default public long ticksToCalendarTicks(long tick) {
        return this.getCalendarTicks() - this.getTicks() + tick;
    }

    default public long getTotalHours() {
        return ICalendar.getTotalHours(this.getTicks());
    }

    default public long getTotalCalendarHours() {
        return ICalendar.getTotalHours(this.getCalendarTicks());
    }

    default public long getTotalDays() {
        return ICalendar.getTotalDays(this.getTicks());
    }

    default public long getTotalCalendarDays() {
        return ICalendar.getTotalDays(this.getCalendarTicks());
    }

    default public long getTotalMonths() {
        return ICalendar.getTotalMonths(this.getTicks(), this.getCalendarDaysInMonth());
    }

    default public long getTotalCalendarMonths() {
        return ICalendar.getTotalMonths(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public long getTotalYears() {
        return ICalendar.getTotalYears(this.getTicks(), this.getCalendarDaysInMonth());
    }

    default public long getTotalCalendarYears() {
        return ICalendar.getTotalYears(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public long getCalendarDayTime() {
        return (this.getCalendarTicks() - 6000L) % 24000L;
    }

    default public int getCalendarDayOfMonth() {
        return ICalendar.getDayOfMonth(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public float getCalendarFractionOfMonth() {
        return ICalendar.getFractionOfMonth(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public float getCalendarFractionOfYear() {
        return ICalendar.getFractionOfYear(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public MutableComponent getCalendarDayOfYear() {
        return Day.getDayName(this.getTotalCalendarDays(), this.getCalendarMonthOfYear(), this.getCalendarDayOfMonth());
    }

    default public Month getCalendarMonthOfYear() {
        return ICalendar.getMonthOfYear(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public long getCalendarTicksInMonth() {
        return ICalendar.getCalendarTicksInMonth(this.getCalendarDaysInMonth());
    }

    default public long getCalendarTicksInYear() {
        return ICalendar.getCalendarTicksInYear(this.getCalendarDaysInMonth());
    }

    default public MutableComponent getCalendarTimeAndDate() {
        return ICalendar.getTimeAndDate(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public MutableComponent getTimeDelta(long ticks) {
        return ICalendar.getTimeDelta(ticks, this.getCalendarDaysInMonth());
    }
}

