/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Month;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum Day {
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY;

    private static final Map<String, String> BIRTHDAYS;
    private static final Day[] VALUES;

    public static Day valueOf(int i) {
        return i < 0 ? MONDAY : (i >= VALUES.length ? SUNDAY : VALUES[i]);
    }

    public static MutableComponent getDayName(long totalDays, Month month, int dayOfMonth) {
        String birthday = BIRTHDAYS.get(month.name() + dayOfMonth);
        if (birthday != null) {
            return Component.m_237110_((String)"tfc.tooltip.calendar_birthday", (Object[])new Object[]{birthday});
        }
        Day day = Day.valueOf((int)totalDays % 7);
        return Helpers.translateEnum(day);
    }

    static {
        BIRTHDAYS = new HashMap<String, String>();
        VALUES = Day.values();
        BIRTHDAYS.put("JULY7", "Bioxx");
        BIRTHDAYS.put("JUNE18", "Kitty");
        BIRTHDAYS.put("OCTOBER2", "Dunk");
        BIRTHDAYS.put("MAY1", "Dries");
        BIRTHDAYS.put("DECEMBER9", "Alcatraz");
        BIRTHDAYS.put("FEBRUARY31", "Bunsan");
        BIRTHDAYS.put("MARCH14", "Claycorp");
        BIRTHDAYS.put("DECEMBER1", "LightningShock");
        BIRTHDAYS.put("JANUARY20", "Therighthon");
        BIRTHDAYS.put("FEBRUARY21", "CtrlAltDavid");
        BIRTHDAYS.put("MARCH10", "Disastermoo");
    }
}

