/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonObject;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ItemDefinition;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class Sluiceable
extends ItemDefinition {
    public static final DataManager<Sluiceable> MANAGER = new DataManager<Sluiceable>(Helpers.identifier("sluicing"), "sluicing", Sluiceable::new, Sluiceable::new, Sluiceable::encode, Packet::new);
    public static final IndirectHashCollection<Item, Sluiceable> CACHE = IndirectHashCollection.create(ItemDefinition::getValidItems, MANAGER::getValues);
    private final ResourceLocation lootTable;

    @Nullable
    public static Sluiceable get(ItemStack item) {
        for (Sluiceable sluiceable : CACHE.getAll(item.m_41720_())) {
            if (!sluiceable.matches(item)) continue;
            return sluiceable;
        }
        return null;
    }

    public Sluiceable(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.lootTable = JsonHelpers.getResourceLocation(json, "loot_table");
    }

    public Sluiceable(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        this.lootTable = buffer.m_130281_();
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.m_130070_(this.lootTable.toString());
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public static class Packet
    extends DataManagerSyncPacket<Sluiceable> {
    }
}

