/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.common.TFCCreativeTabs;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.IcePileBlock;
import net.dries007.tfc.common.blocks.MoltenBlock;
import net.dries007.tfc.common.blocks.PouredGlassBlock;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCLightBlock;
import net.dries007.tfc.common.blocks.devices.IngotPileBlock;
import net.dries007.tfc.common.blocks.devices.ScrapingBlock;
import net.dries007.tfc.common.blocks.devices.SheetPileBlock;
import net.dries007.tfc.common.blocks.plant.BodyPlantBlock;
import net.dries007.tfc.common.blocks.plant.BranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.GrowingBranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.common.blocks.plant.fruit.GrowingFruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.rock.RockAnvilBlock;
import net.dries007.tfc.common.blocks.rock.RockDisplayCategory;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.capabilities.forge.ForgeStep;
import net.dries007.tfc.common.capabilities.forge.ForgingBonus;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.common.items.MoldItem;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.util.Drinkable;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.calendar.Day;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.KoppenClimateClassification;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class SelfTests {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean THROW_ON_SELF_TEST_FAIL = true;
    private static boolean EXTERNAL_ERROR = false;

    public static void runWorldVersionTest() {
    }

    public static void runClientSelfTests() {
        MinecraftForge.EVENT_BUS.post((Event)new ClientSelfTestEvent());
        if (Helpers.TEST_ENVIRONMENT) {
            Stopwatch tick = Stopwatch.createStarted();
            SelfTests.throwIfAny(SelfTests.validateOwnBlockEntities(), SelfTests.validateModels(), SelfTests.validateTranslationsAndCreativeTabs());
            LOGGER.info("Client self tests passed in {}", (Object)tick.stop());
        }
    }

    public static void runServerSelfTests() {
        if (Helpers.TEST_ENVIRONMENT) {
            Stopwatch tick = Stopwatch.createStarted();
            SelfTests.throwIfAny(SelfTests.validateOwnBlockLootTables(), SelfTests.validateOwnBlockMineableTags(), SelfTests.validateOwnBlockTags(), EXTERNAL_ERROR);
            LOGGER.info("Server self tests passed in {}", (Object)tick.stop());
        }
    }

    public static void runDataPackTests(RecipeManager manager) {
        Stopwatch tick = Stopwatch.createStarted();
        SelfTests.throwIfAny(SelfTests.validateReplaceableBlocksAreTagged(), SelfTests.validateFoodsAreFoods(), SelfTests.validateJugDrinkable(), SelfTests.validateCollapseRecipeTags(manager), SelfTests.validateLandslideRecipeTags(manager), SelfTests.validateMetalTagsAreCorrect(Metal::getIngotIngredient, TFCTags.Items.PILEABLE_INGOTS), SelfTests.validateMetalTagsAreCorrect(Metal::getDoubleIngotIngredient, TFCTags.Items.PILEABLE_DOUBLE_INGOTS), SelfTests.validateMetalTagsAreCorrect(Metal::getSheetIngredient, TFCTags.Items.PILEABLE_SHEETS), SelfTests.validatePotFluidUsability(manager), SelfTests.validateBarrelFluidUsability(manager), SelfTests.validateUniqueBloomeryRecipes(manager), SelfTests.validateUniqueLoomRecipes(manager), SelfTests.validateMoldsCanContainCastingIngredients(manager), SelfTests.validateHeatingRecipeIngredientsAreHeatable(manager));
        LOGGER.info("Data pack self tests passed in {}", (Object)tick.stop());
    }

    @Deprecated
    public static <T> Stream<T> stream(IForgeRegistry<T> registry, String modID) {
        return registry.getValues().stream().filter(e -> {
            ResourceLocation key = registry.getKey(e);
            assert (key != null);
            return key.m_135827_().equals(modID);
        });
    }

    public static <T> Stream<T> stream(Registry<T> registry, String modID) {
        return registry.m_123024_().filter(e -> {
            ResourceLocation key = registry.m_7981_(e);
            assert (key != null);
            return key.m_135827_().equals(modID);
        });
    }

    public static Function<Block, Stream<BlockState>> states(Predicate<BlockState> filter) {
        return block -> block.m_49965_().m_61056_().stream().filter(filter);
    }

    public static boolean validateBlockEntities(Stream<Block> blocks, Logger logger) {
        ArrayList fbeButNoEbe = new ArrayList();
        ArrayList ebeButNoFbe = new ArrayList();
        ArrayList ebButNoEbe = new ArrayList();
        blocks.forEach(b -> {
            IForgeBlockExtension ex;
            if (b instanceof IForgeBlockExtension && (ex = (IForgeBlockExtension)b).getExtendedProperties().hasBlockEntity() && !(b instanceof EntityBlockExtension)) {
                fbeButNoEbe.add(b);
            }
            if (!(!(b instanceof EntityBlockExtension) || b instanceof IForgeBlockExtension && (ex = (IForgeBlockExtension)b).getExtendedProperties().hasBlockEntity())) {
                ebeButNoFbe.add(b);
            }
            if (b instanceof EntityBlock && !(b instanceof EntityBlockExtension)) {
                ebButNoEbe.add(b);
            }
        });
        return SelfTests.logRegistryErrors("{} blocks found that declare a block entity in IForgeBlockExtension but do not implement EntityBlockExtension", fbeButNoEbe, logger) | SelfTests.logRegistryErrors("{} blocks found that implement EntityBlockExtension but do not declare a block entity in IForgeBlockExtension", ebeButNoFbe, logger) | SelfTests.logRegistryErrors("{} blocks found that implement EntityBlock but do not implement EntityBlockExtension", ebButNoEbe, logger);
    }

    public static <T extends Enum<?>> boolean validateTranslations(Logger logger, Set<String> missingTranslations, Class<? extends T> enumClass) {
        boolean errors = false;
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            errors |= SelfTests.validateTranslation(logger, missingTranslations, (Component)Helpers.translateEnum(enumConstant));
        }
        return errors;
    }

    public static boolean validateTranslation(Logger logger, Set<String> missingTranslations, Component component) {
        ComponentContents componentContents = component.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            if (!Language.m_128107_().m_6722_(translatable.m_237508_())) {
                missingTranslations.add(translatable.m_237508_());
            }
        } else {
            logger.error("Tried to check the translation key of a non-translatable-component, this is almost certainly a bug, {}", (Object)component);
            return true;
        }
        return false;
    }

    public static boolean validateBlockLootTables(Stream<Block> blocks, Logger logger) {
        Collection lootTables = ServerLifecycleHooks.getCurrentServer().m_278653_().m_278706_(LootDataType.f_278413_);
        List<Block> missingLootTables = blocks.filter(b -> !lootTables.contains(b.m_60589_())).filter(b -> !b.m_49966_().m_60795_()).toList();
        return SelfTests.logRegistryErrors("{} blocks found with a non-existent loot table:", missingLootTables, logger);
    }

    public static boolean validateBlocksHaveTag(Stream<Block> blocks, TagKey<Block> tag, Logger logger) {
        return SelfTests.logRegistryErrors("{} blocks are missing the #" + tag.f_203868_() + " tag", blocks.filter(b -> !Helpers.isBlock(b, tag)).toList(), logger);
    }

    public static <T> boolean logErrors(String error, Collection<T> errors, Logger logger) {
        if (!errors.isEmpty()) {
            logger.error(error, (Object)errors.size());
            errors.forEach(e -> logger.error("  {}", e));
            return true;
        }
        return false;
    }

    public static <T> boolean logWarnings(String error, Collection<T> errors, Logger logger) {
        if (!errors.isEmpty()) {
            logger.warn(error, (Object)errors.size());
            errors.forEach(e -> logger.warn("  {}", e));
            return true;
        }
        return false;
    }

    public static <T> boolean logRegistryErrors(String error, Collection<T> errors, Logger logger) {
        if (!errors.isEmpty()) {
            logger.error(error, (Object)errors.size());
            errors.forEach(e -> logger.error("  {} of {}", (Object)e.toString(), (Object)e.getClass().getSimpleName()));
            return true;
        }
        return false;
    }

    public static void throwIfAny(boolean ... errors) {
        for (boolean error : errors) {
            if (error && Helpers.ASSERTIONS_ENABLED) {
                throw new AssertionError((Object)"Self Tests Failed! Fix the above errors!");
            }
        }
    }

    public static void reportExternalError() {
        EXTERNAL_ERROR = true;
    }

    private static boolean validateOwnBlockEntities() {
        return SelfTests.validateBlockEntities(SelfTests.stream(BuiltInRegistries.f_256975_, "tfc"), LOGGER);
    }

    private static boolean validateOwnBlockLootTables() {
        Set expectedNoLootTableBlocks = Stream.of(TFCBlocks.PLACED_ITEM, TFCBlocks.PIT_KILN, TFCBlocks.LOG_PILE, TFCBlocks.BURNING_LOG_PILE, TFCBlocks.BLOOM, TFCBlocks.MOLTEN, TFCBlocks.SCRAPING, TFCBlocks.THATCH_BED, TFCBlocks.INGOT_PILE, TFCBlocks.DOUBLE_INGOT_PILE, TFCBlocks.SHEET_PILE, TFCBlocks.PLANTS.get(Plant.GIANT_KELP_PLANT), TFCBlocks.PUMPKIN, TFCBlocks.MELON, TFCBlocks.CAKE, TFCBlocks.CALCITE, TFCBlocks.ICICLE, TFCBlocks.RIVER_WATER, TFCBlocks.SPRING_WATER, TFCBlocks.LIGHT, TFCBlocks.SALTWATER_BUBBLE_COLUMN, TFCBlocks.FRESHWATER_BUBBLE_COLUMN, TFCBlocks.HOT_POURED_GLASS, TFCBlocks.GLASS_BASIN, TFCBlocks.JARS).map(Supplier::get).collect(Collectors.toSet());
        ImmutableSet expectedNoLootTableClasses = ImmutableSet.of(BodyPlantBlock.class, GrowingFruitTreeBranchBlock.class, LiquidBlock.class, BranchingCactusBlock.class, GrowingBranchingCactusBlock.class, PouredGlassBlock.class, (Object[])new Class[0]);
        return SelfTests.validateBlockLootTables(SelfTests.stream(BuiltInRegistries.f_256975_, "tfc").filter(b -> !expectedNoLootTableBlocks.contains(b)).filter(arg_0 -> SelfTests.lambda$validateOwnBlockLootTables$11((Set)expectedNoLootTableClasses, arg_0)), LOGGER);
    }

    private static boolean validateOwnBlockMineableTags() {
        Set expectedNotMineableBlocks = Stream.of(TFCBlocks.PLACED_ITEM, TFCBlocks.PIT_KILN, TFCBlocks.SCRAPING, TFCBlocks.CANDLE, TFCBlocks.DYED_CANDLE.values(), TFCBlocks.CANDLE_CAKE, TFCBlocks.CAKE, TFCBlocks.DYED_CANDLE_CAKES.values(), TFCBlocks.HOT_POURED_GLASS, TFCBlocks.GLASS_BASIN, TFCBlocks.POURED_GLASS, TFCBlocks.COLORED_POURED_GLASS.values()).flatMap(Helpers::flatten).map(Supplier::get).collect(Collectors.toSet());
        Set<TagKey<Block>> mineableTags = Set.of(BlockTags.f_144280_, BlockTags.f_144281_, BlockTags.f_144282_, BlockTags.f_144283_, TFCTags.Blocks.MINEABLE_WITH_PROPICK, TFCTags.Blocks.MINEABLE_WITH_HAMMER, TFCTags.Blocks.MINEABLE_WITH_KNIFE, TFCTags.Blocks.MINEABLE_WITH_SCYTHE, TFCTags.Blocks.MINEABLE_WITH_CHISEL);
        List<Block> missingTag = SelfTests.stream(BuiltInRegistries.f_256975_, "tfc").filter(b -> !(b instanceof LiquidBlock) && b.m_155943_() > 0.0f && !expectedNotMineableBlocks.contains(b) && mineableTags.stream().noneMatch(t -> Helpers.isBlock(b, (TagKey<Block>)t))).toList();
        return SelfTests.logRegistryErrors("{} non-fluid blocks have no mineable_with_<tool> tag.", missingTag, LOGGER);
    }

    private static boolean validateOwnBlockTags() {
        return SelfTests.validateBlocksHaveTag(SelfTests.stream(BuiltInRegistries.f_256975_, "tfc").filter(b -> b instanceof WallBlock), (TagKey<Block>)BlockTags.f_13032_, LOGGER) | SelfTests.validateBlocksHaveTag(SelfTests.stream(BuiltInRegistries.f_256975_, "tfc").filter(b -> b instanceof StairBlock), (TagKey<Block>)BlockTags.f_13030_, LOGGER) | SelfTests.validateBlocksHaveTag(SelfTests.stream(BuiltInRegistries.f_256975_, "tfc").filter(b -> b instanceof SlabBlock), (TagKey<Block>)BlockTags.f_13031_, LOGGER);
    }

    private static boolean validateModels() {
        BlockModelShaper shaper = Minecraft.m_91087_().m_91289_().m_110907_();
        BakedModel missingModel = shaper.m_110881_().m_119409_();
        TextureAtlasSprite missingParticle = missingModel.m_6160_();
        List<BlockState> missingModelErrors = SelfTests.stream(BuiltInRegistries.f_256975_, "tfc").flatMap(SelfTests.states(s -> s.m_60799_() == RenderShape.MODEL && shaper.m_110893_(s) == missingModel)).toList();
        List<BlockState> missingParticleErrors = SelfTests.stream(BuiltInRegistries.f_256975_, "tfc").flatMap(SelfTests.states(s -> !s.m_60795_() && !(s.m_60734_() instanceof IngotPileBlock) && !(s.m_60734_() instanceof SheetPileBlock) && !(s.m_60734_() instanceof ScrapingBlock) && shaper.m_110882_(s) == missingParticle)).toList();
        return SelfTests.logErrors("{} block states with missing models:", missingModelErrors, LOGGER) | SelfTests.logErrors("{} block states with missing particles:", missingParticleErrors, LOGGER);
    }

    private static boolean validateTranslationsAndCreativeTabs() {
        Set missingTranslations = Bootstrap.m_135886_();
        ArrayList stacks = new ArrayList();
        HashSet items = new HashSet();
        boolean error = false;
        TFCCreativeTabs.generators().forEach(gen -> gen.m_257865_(null, (stack, visibility) -> {
            stacks.add(stack);
            items.add(stack.m_41720_());
        }));
        Set<Class<PouredGlassBlock>> blocksWithNoCreativeTabItem = Set.of(SnowPileBlock.class, IcePileBlock.class, BloomBlock.class, MoltenBlock.class, TFCLightBlock.class, RockAnvilBlock.class, PouredGlassBlock.class);
        List<Item> missingItems = SelfTests.stream(BuiltInRegistries.f_257033_, "tfc").filter(item -> {
            BlockItem bi;
            return !items.contains(item) && item != TFCItems.FILLED_PAN.get() && (!(item instanceof BlockItem) || !blocksWithNoCreativeTabItem.contains((bi = (BlockItem)item).m_40614_().getClass()));
        }).toList();
        error |= SelfTests.logErrors("{} items were not found in any TFC creative tab", missingItems, LOGGER);
        for (ItemStack stack : stacks) {
            error |= SelfTests.validateTranslation(LOGGER, missingTranslations, stack.m_41786_());
        }
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        BuiltInRegistries.f_256894_.forEach(sound -> Optional.ofNullable(soundManager.m_120384_(sound.m_11660_())).map(WeighedSoundEvents::m_120453_).ifPresent(subtitle -> SelfTests.validateTranslation(LOGGER, missingTranslations, subtitle)));
        for (CreativeModeTab tab : CreativeModeTabs.m_257478_()) {
            error |= SelfTests.validateTranslation(LOGGER, missingTranslations, tab.m_40786_());
        }
        return (error |= Stream.of(ForgeStep.class, ForgingBonus.class, Metal.Tier.class, Heat.class, Nutrient.class, Size.class, Weight.class, Day.class, Month.class, KoppenClimateClassification.class, ForestType.class, RockDisplayCategory.class, RockDisplayCategory.class).anyMatch(clazz -> SelfTests.validateTranslations(LOGGER, missingTranslations, clazz))) | SelfTests.logErrors("{} missing translation keys:", missingTranslations, LOGGER);
    }

    private static boolean validateFoodsAreFoods() {
        List<Item> errors = Helpers.allItems(TFCTags.Items.FOODS).filter(item -> !FoodCapability.has(item.m_7968_())).toList();
        return SelfTests.logWarnings("{} items were in the tfc:foods tag but lacked a food definition", errors, LOGGER);
    }

    private static boolean validateJugDrinkable() {
        List<Fluid> errors = Helpers.allFluids(TFCTags.Fluids.USABLE_IN_JUG).filter(fluid -> Drinkable.get(fluid) == null).toList();
        return SelfTests.logWarnings("{} fluids were in the tfc:usable_in_jug tag but lack a Drinkable json entry", errors, LOGGER);
    }

    private static boolean validateCollapseRecipeTags(RecipeManager manager) {
        List<Block> errors = manager.m_44013_((RecipeType)TFCRecipeTypes.COLLAPSE.get()).stream().flatMap(recipe -> recipe.getBlockIngredient().all()).filter(block -> !Helpers.isBlock(block, TFCTags.Blocks.CAN_COLLAPSE)).toList();
        return SelfTests.logErrors("{} blocks were defined in a collapse recipe but lack the tfc:can_collapse tag", errors, LOGGER);
    }

    private static boolean validateLandslideRecipeTags(RecipeManager manager) {
        List<Block> errors = manager.m_44013_((RecipeType)TFCRecipeTypes.LANDSLIDE.get()).stream().flatMap(recipe -> recipe.getBlockIngredient().all()).filter(block -> !Helpers.isBlock(block, TFCTags.Blocks.CAN_LANDSLIDE)).toList();
        return SelfTests.logErrors("{} blocks were defined in a landslide recipe but lack the tfc:can_landslide tag", errors, LOGGER);
    }

    private static boolean validateMetalTagsAreCorrect(Function<Metal, Ingredient> metalItemType, TagKey<Item> containingTag) {
        boolean error = false;
        for (Metal metal : Metal.MANAGER.getValues()) {
            @Nullable Ingredient ingredient = metalItemType.apply(metal);
            if (ingredient == null) continue;
            Set metalItems = Arrays.stream(ingredient.m_43908_()).map(ItemStack::m_41720_).filter(item -> !Helpers.isItem(item, containingTag)).collect(Collectors.toSet());
            error |= SelfTests.logErrors("{} items defined in the tag for the metal " + metal.getId() + " were missing from the #" + containingTag.f_203868_() + " tag", metalItems, LOGGER);
        }
        return error;
    }

    private static boolean validatePotFluidUsability(RecipeManager manager) {
        List<Fluid> errors = manager.m_44013_((RecipeType)TFCRecipeTypes.POT.get()).stream().flatMap(recipe -> recipe.getFluidIngredient().ingredient().all()).filter(fluid -> !Helpers.isFluid(fluid, TFCTags.Fluids.USABLE_IN_POT)).toList();
        return SelfTests.logErrors("{} fluids are listed in pot recieps that are not tagged as tfc:usable_in_pot", errors, LOGGER);
    }

    private static boolean validateBarrelFluidUsability(RecipeManager manager) {
        List<Fluid> errors = manager.m_44051_().stream().filter(recipe -> recipe instanceof BarrelRecipe).map(recipe -> (BarrelRecipe)recipe).flatMap(recipe -> Stream.concat(recipe.getInputFluid().ingredient().all(), Stream.of(recipe.getOutputFluid().getFluid()))).filter(fluid -> !fluid.m_6212_(Fluids.f_76191_) && !Helpers.isFluid(fluid, TFCTags.Fluids.USABLE_IN_BARREL)).toList();
        return SelfTests.logErrors("{} fluids are listed in barrel recipes that are not tagged as tfc:usable_in_barrel", errors, LOGGER);
    }

    private static boolean validateUniqueBloomeryRecipes(RecipeManager manager) {
        List<Fluid> errors = manager.m_44013_((RecipeType)TFCRecipeTypes.BLOOMERY.get()).stream().flatMap(recipe -> recipe.getInputFluid().ingredient().all()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(m -> (Long)m.getValue() > 1L).map(Map.Entry::getKey).toList();
        return SelfTests.logErrors("{} fluids appeared in multiple bloomery recipes. Currently, every bloomery recipe must have a unique fluid input in order to work", errors, LOGGER);
    }

    private static boolean validateUniqueLoomRecipes(RecipeManager manager) {
        List<Item> errors = manager.m_44013_((RecipeType)TFCRecipeTypes.LOOM.get()).stream().flatMap(recipe -> Arrays.stream(recipe.getItemStackIngredient().ingredient().m_43908_())).map(ItemStack::m_41720_).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(m -> (Long)m.getValue() > 1L).map(Map.Entry::getKey).toList();
        return SelfTests.logErrors("{} items appeared in multiple loom recipes. Currently, every loom recipe must have a unique item input in order to work", errors, LOGGER);
    }

    private static boolean validateMoldsCanContainCastingIngredients(RecipeManager manager) {
        List errors = manager.m_44013_((RecipeType)TFCRecipeTypes.CASTING.get()).stream().flatMap(recipe -> Arrays.stream(recipe.getIngredient().m_43908_()).filter(stack -> stack.m_41720_() instanceof MoldItem).flatMap(stack -> recipe.getFluidIngredient().ingredient().all().filter(fluid -> !Helpers.isFluid(fluid, ((MoldItem)stack.m_41720_()).getFluidTag())))).toList();
        return SelfTests.logErrors("{} fluids were found that were given as ingredients in a casting recipe that could not be put into the specified mold. This probably means that you need to add fluids to the tfc:usable_in_tool_head_mold or tfc:usable_in_ingot_mold tag.", errors, LOGGER);
    }

    private static boolean validateHeatingRecipeIngredientsAreHeatable(RecipeManager manager) {
        List<ItemStack> errors = manager.m_44013_((RecipeType)TFCRecipeTypes.HEATING.get()).stream().flatMap(recipe -> Arrays.stream(recipe.getIngredient().m_43908_())).filter(stack -> HeatCapability.getDefinition(stack) == null).toList();
        return SelfTests.logErrors("{} items found as ingredients to heating recipes without a heat definition!", errors, LOGGER);
    }

    private static boolean validateReplaceableBlocksAreTagged() {
        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)Helpers.identifierMC("replaceable"));
        List<Block> notTagged = BuiltInRegistries.f_256975_.m_123024_().filter(b -> b.m_49966_().m_247087_() && !Helpers.isBlock(b, (TagKey<Block>)tag) && !BuiltInRegistries.f_256975_.m_7981_(b).m_135827_().equals("minecraft")).toList();
        List<Block> shouldNotBeTagged = Helpers.allBlocks((TagKey<Block>)tag).filter(b -> !b.m_49966_().m_247087_()).toList();
        return SelfTests.logErrors("{} blocks are not tagged as minecraft:replaceable while being replaceable.", notTagged, LOGGER) | SelfTests.logErrors("{} blocks are tagged as minecraft:replaceable while being not replaceable.", shouldNotBeTagged, LOGGER);
    }

    private static /* synthetic */ boolean lambda$validateOwnBlockLootTables$11(Set expectedNoLootTableClasses, Block b) {
        return !expectedNoLootTableClasses.contains(b.getClass());
    }

    public static class ClientSelfTestEvent
    extends Event {
    }
}

