/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class PowderKegExplosion
extends Explosion {
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity source;
    private final float size;

    public PowderKegExplosion(Level level, @Nullable Entity entity, double x, double y, double z, float size) {
        super(level, null, x, y, z, size, false, Explosion.BlockInteraction.DESTROY);
        this.level = level;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.source = entity;
    }

    public void m_46075_(boolean spawnParticles) {
        if (this.level.f_46443_) {
            this.level.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.f_46441_.m_188501_() - this.level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        if (this.size >= 2.0f) {
            this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        } else {
            this.level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
        List affectedBlockPositions = this.m_46081_();
        ObjectArrayList allDrops = new ObjectArrayList();
        Collections.shuffle(affectedBlockPositions, new Random());
        boolean easyMode = (Boolean)TFCConfig.SERVER.powderKegOnlyBreaksNaturalBlocks.get();
        for (BlockPos pos : affectedBlockPositions) {
            BlockState state = this.level.m_8055_(pos);
            if (easyMode ? !Helpers.isBlock(state, TFCTags.Blocks.POWDERKEG_BREAKING_BLOCKS) : Helpers.isBlock(state, TFCTags.Blocks.EXPLOSION_PROOF)) continue;
            if (spawnParticles) {
                double x = (float)pos.m_123341_() + this.level.f_46441_.m_188501_();
                double y = (float)pos.m_123342_() + this.level.f_46441_.m_188501_();
                double z = (float)pos.m_123343_() + this.level.f_46441_.m_188501_();
                double dx = x - this.x;
                double dy = y - this.y;
                double dz = z - this.z;
                double distance = Mth.m_14116_((float)((float)(dx * dx + dy * dy + dz * dz)));
                dx /= distance;
                dy /= distance;
                dz /= distance;
                double scaledPower = 0.5 / (distance / (double)this.size + 0.1);
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (x + this.x) / 2.0, (y + this.y) / 2.0, (z + this.z) / 2.0, dx *= (scaledPower *= (double)(this.level.f_46441_.m_188501_() * this.level.f_46441_.m_188501_() + 0.3f)), dy *= scaledPower, dz *= scaledPower);
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, dx, dy, dz);
            }
            if (state.m_60795_()) continue;
            BlockPos dropPos = pos.m_7949_();
            this.level.m_46473_().m_6180_("explosion_blocks");
            if (state.canDropFromExplosion((BlockGetter)this.level, pos, (Explosion)this) && this.level instanceof ServerLevel) {
                BlockEntity blockentity = state.m_155947_() ? this.level.m_7702_(pos) : null;
                LootParams.Builder lootContext = new LootParams.Builder((ServerLevel)this.level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockentity).m_287289_(LootContextParams.f_81455_, (Object)this.source);
                state.m_287290_(lootContext).forEach(drop -> PowderKegExplosion.m_46067_((ObjectArrayList<Pair<ItemStack, BlockPos>>)allDrops, drop, dropPos));
            }
            state.onBlockExploded(this.level, pos, (Explosion)this);
            this.level.m_46473_().m_7238_();
        }
        for (Pair pair : allDrops) {
            Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private static void m_46067_(ObjectArrayList<Pair<ItemStack, BlockPos>> allDrops, ItemStack drop, BlockPos dropPos) {
        int i = allDrops.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)allDrops.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)drop)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)drop, (int)16);
            allDrops.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!drop.m_41619_()) continue;
            return;
        }
        allDrops.add((Object)Pair.of((Object)drop, (Object)dropPos));
    }
}

